"""
Created on Sep 6, 2022

@author: Robert

This module gives the game structure: setting things up, interaction, and the motion.

YOU DO NOT NEED TO CHANGE THIS FILE AT ALL.
"""
import turtle
import StudentGameTheme


class Point:
    """
    Make it easy to use X and Y values in the program.
    """
    __slots__ = ['x', 'y']
    def __init__(self, x, y):
        self.x = x
        self.y = y


def isInBounds(projectile):
    """
    Check if the projectile is within the Game bounds.
    """
    return -StudentGameTheme.screenWidth / 2 < projectile.xcor() < StudentGameTheme.screenWidth / 2 and \
           -StudentGameTheme.screenHeight / 2 < projectile.ycor() < StudentGameTheme.screenHeight / 2


def isHit(projectile, target):
    """
    Check if the projectile hits the target.

    Not precise for turned turtles but close enough for the first game
    """
    width = 5 * (projectile.turtlesize()[0] + target.turtlesize()[0]) + projectile.turtlesize()[2] + target.turtlesize()[2]
    height = 5 * (projectile.turtlesize()[1] + target.turtlesize()[1]) + projectile.turtlesize()[2] + target.turtlesize()[2]
    return abs(projectile.xcor() - target.xcor()) < width and abs(projectile.ycor() - target.ycor()) < height


def aim(x, y):
    """
    Allow player to aim the cannon before shooting based on the XY-coordinate of the mouse.

    Activated when the player clicks on the cannon and until the mouse is released.
    """
    StudentGameTheme.aim(Point(x, y), theCannon)
    theProjectile.hideturtle()
    theMessage.hideturtle()
    theMessage.clear()
    theScreen.update()


def shoot(x, y):
    """
    Allow player to shoot the projectile at the target based on the XY-coordinate of the mouse.

    Activated when the player releases the mouse.
    """
    StudentGameTheme.drawTarget(theTarget)
    StudentGameTheme.drawProjectile(theProjectile)
    StudentGameTheme.shoot(Point(x, y), theVelocity, theCannon, theProjectile)
    theScreen.update()
    theScreen.ontimer(move, 10)


def move():
    """
    Moves the projectile until it either hits the target or leaves the screen.
    """
    StudentGameTheme.move(theVelocity, theProjectile)

    keepMoving = True
    if isHit(theProjectile, theTarget):
        StudentGameTheme.targetHit(theVelocity, theProjectile, theTarget, theMessage)
        keepMoving = False
    elif not isInBounds(theProjectile):
        StudentGameTheme.targetMissed(theProjectile, theTarget, theMessage)
        theProjectile.hideturtle()
        keepMoving = False

    theScreen.update()
    if keepMoving:
        theScreen.ontimer(move, 40)


def setup():
    """
    Sets up the initial game scene
    """
    # make the game interactive
    theScreen.tracer(False)
    theCannon.ondrag(aim)
    theCannon.onrelease(shoot)
    # draw the game based on student's code
    StudentGameTheme.drawCannon(theCannon)
    StudentGameTheme.drawTarget(theTarget)
    # show the results
    theScreen.update()


# set up the game variables
theScreen = turtle.Screen()
theScreen.setup(StudentGameTheme.screenWidth, StudentGameTheme.screenHeight)
theScreen.title(StudentGameTheme.gameName)
theMessage = turtle.Turtle()
theMessage.hideturtle()
theMessage.penup()
StudentGameTheme.drawScene(theScreen, theMessage)

theTarget = turtle.Turtle()
theTarget.penup()
theProjectile = turtle.Turtle()
theProjectile.hideturtle()
theProjectile.penup()
theCannon = turtle.Turtle()
theCannon.penup()

theVelocity = Point(0, 0)
setup()

# play the game forever
theScreen.mainloop()
