"""
Created on Sep 6, 2022

@author: YOUR NAME HERE!!

This module 'mods' the game, with these functions giving you control over its look and action.
"""
import turtle

# choose the size of your game window
screenWidth = 600
screenHeight = 600
# choose a name for your game to appear in the title bar of the game window
gameName = 'AIM IT'


def drawScene(screen, message):
    """
    Draw the game's setting and include a welcome message if you want.

    Whatever turtles you create here or drawing that you do here will serve as the game's background
    to set the game's theme, but will not be part of the game's action.

    Note, these turtles may cover the message if they overlap.
    """
    screen.bgcolor('lightblue')
    t = turtle.Turtle()
    t.shape('circle')
    t.shapesize(30)
    message.sety(-250)
    message.color('blue')
    message.write('Click on the cannon to aim!', align='center', font=('Arial', 48, 'normal'))



def drawCannon(cannon):
    """
    Draw the interactive piece of the game that the player uses to aim and launch the projectile towards the target.
    """
    cannon.shape('square')
    cannon.color('orange')
    cannon.shapesize(1, 4)


def drawTarget(target):
    """
    Draw the target to be hit by the projectile.
    """
    target.shape('square')
    target.shapesize(4)
    target.color('blue')
    target.setheading(45)
    target.goto(200, 200)


def drawProjectile(projectile):
    """
    Draw the projectile that will be launched towards the target.
    """
    projectile.shape('circle')
    projectile.color('red')
    projectile.showturtle()


def aim(mousePoint, cannon):
    """
    Control how the cannon is aimed towards the target based on the (x, y) position of the player's mouse.
    """
    cannon.setheading(cannon.towards(mousePoint.x, mousePoint.y))


def shoot(mousePoint, velocity, cannon, projectile):
    """
    Control how fast to shoot the projectile based on the (x, y) position of the player's mouse.
    """
    projectile.goto(cannon.xcor(), cannon.ycor())
    projectile.setheading(cannon.heading())
    velocity.x = 0.04 * (mousePoint.x - projectile.xcor())
    velocity.y = 0.04 * (mousePoint.y - projectile.ycor())


def move(velocity, projectile):
    """
    Control how the projectile moves towards the target.
    """
    projectile.setx(projectile.xcor() + velocity.x)
    projectile.sety(projectile.ycor() + velocity.y)


def targetHit(velocity, projectile, target, message):
    """
    Determine what happens after the target has been hit by the projectile.
    """
    target.color('green')
    message.sety(-250)
    message.color('green')
    message.write('GREAT SHOT!', align='center', font=('Arial', 60, 'normal'))


def targetMissed(projectile, target, message):
    """
    Determine what happens after a projectile shot misses the target.
    """
    target.color('red')
    message.sety(-250)
    message.color('red')
    message.write('JUST MISSED!', align='center', font=('Arial', 60, 'normal'))
