"""
Created on Jun 20, 2019

@author: Shannon, Yesenia, Robert

This module gives the game structure: turn-taking, and determining a win.

YOU DO NOT NEED TO CHANGE THIS FILE AT ALL.
"""
import random
import turtle
import time
import SmartPlayer
import UserPlayer
import Chip


def playGame(gameOver, smartTurn, chips, numChips, gameWindow):
    """
    Starts the game by asking how many chips should be in play and
    letting the user go first.
    """
    if smartTurn and not gameOver:  # NPC turn
        # give NPC 0-2 seconds to think of their next move
        UserPlayer.drawText("I'm thinking...", -120, 16, gameWindow)
        thinkTime = random.randint(0, 2)
        time.sleep(thinkTime)
        clearScene(gameWindow)

        # NPC removes chips
        numTake = SmartPlayer.move(numChips) if numChips >= 3 else numChips
        gameOver = checkWin('I', numTake, numChips, gameWindow)
        numChips -= numTake
        smartTurn = False

    elif not gameOver:  # User turn
        # ask user how many chips to remove
        clearScene(gameWindow)
        numTake = UserPlayer.move(numChips, gameWindow)
        clearScene(gameWindow)
        gameOver = checkWin('You', numTake, numChips, gameWindow)
        numChips -= numTake
        smartTurn = True

    # update scene to reflect new game state
    drawChips(chips, numChips, gameWindow)
    time.sleep(2)

    return gameOver, smartTurn, numChips


def checkWin(player, numTake, numChips, gameWindow):
    """
    Check to see if the last player won. This is true if there are no chips left.
    The string tells if it is "I" (the computer) or "You" (the user) who wins.
    This method also sets the text to tell the last move.
    """
    # update user on what was the last move played
    plural = 's' if numTake != 1 else ''
    text = f"Chips: {numChips}\n {player} take {numTake} chip{plural},\n leaving {numChips - numTake}"
    UserPlayer.drawText(text, 0, 30, gameWindow)
    time.sleep(2)
    clearScene(gameWindow)

    # check if there is a winner
    if (numChips - numTake) <= 0:
        text = f"{player} win!"
        UserPlayer.drawText(text, 0.0, 50, gameWindow)
        return True
    else:
        return False


def drawChips(chips, numChips, gameWindow):
    """
    Draw the current number of chips
    """
    for i in range(numChips):
        Chip.draw(*chips[i])
    gameWindow.update()


def clearScene(gameWindow):
    """
    Reset screen to prepare for a new set of chips
    """
    for t in gameWindow.turtles():
        t.reset()
        t.hideturtle()
    gameWindow.update()


def setup():
    """
    Sets up the initial game window/scene
    """
    gameWindow = turtle.Screen()  # set gameWindow to the window object
    gameWindow.setup(400, 300)  # set the window size to 400 by 300 pixels
    gameWindow.title('NIM')  # set the title of the game window
    gameWindow.bgcolor('white')  # set the window background color
    gameWindow.colormode(255)  # set r, g, and b to be in the range 0...255
    gameWindow.tracer(False)

    # determine how many chips and who goes first
    numChips = UserPlayer.decideNumChips(gameWindow)

    # limit where the chips can appear on the screen
    xBound = gameWindow.window_width() / 2.8
    yBound = gameWindow.window_height() / 2.8

    # make chips
    chips = []
    random.seed(45)
    for _ in range(numChips):
        x = random.uniform(-xBound, xBound)
        y = random.uniform(-yBound, yBound)
        r = random.randint(0, 255)
        g = random.randint(0, 255)
        b = random.randint(0, 255)
        chips.append([x, y, r, g, b])

    # draw initial scene
    drawChips(chips, numChips, gameWindow)
    time.sleep(2)
    return gameWindow, chips


# set up game
gameWindow, chips = setup()

# play the game until game over
gameOver = False
numChips = len(chips)
smartTurn = SmartPlayer.goFirst(numChips)
while not gameOver:
    gameOver, smartTurn, numChips = playGame(gameOver, smartTurn, chips, numChips, gameWindow)

# exit the game when the user clicks on the game window
gameWindow.exitonclick()
