"""
Created on Jun 20, 2019

@author: Shannon, Yesenia, Robert

This module represents an interactive Nim player.

YOU DO NOT NEED TO CHANGE THIS MODULE AT ALL.
"""
import turtle


# Global Variables
chipsRemoved = 0
hasClicked = False


def drawText(text, yCord, fontSize, gameWindow):
    """
    Draw the text
    """
    turtleText = turtle.Turtle()
    turtleText.hideturtle()
    turtleText.speed('fastest')
    turtleText.penup()
    turtleText.sety(yCord)
    turtleText.write(text, move=False, align='center', font=('Arial', fontSize, 'normal'))
    gameWindow.update()


def drawButton(button, text, xCord, yCord, buttonSize, gameWindow):
    """
    Draw the button for user input options
    """
    cursorSize = 20
    fontSize = 18
    fontFormat = ('Arial', fontSize, 'bold')

    # draw button
    button.penup()
    button.goto(xCord, yCord)
    button.shape('square')
    button.shapesize(buttonSize / cursorSize, outline=2)
    button.color('black', 'red')

    # Draw button text
    marker = turtle.Turtle()
    marker.hideturtle()
    marker.penup()
    marker.goto(button.xcor(), button.ycor() - buttonSize / 2 - fontSize - 2)
    marker.write(text, align='center', font=fontFormat)

    gameWindow.update()


def decideNumChips(gameWindow):
    """
    The user gets to decide the number of chips in the game.
    """
    num = gameWindow.textinput("NIM", "How many chips?")
    return int(num)


def removeChips1(x, y):
    """
    Get the number of chips removed when button 1 clicked
    """
    global chipsRemoved
    global hasClicked
    chipsRemoved = 1
    hasClicked = True


def removeChips2(x, y):
    """
    Get the number of chips removed when button 2 clicked
    """
    global chipsRemoved
    global hasClicked
    chipsRemoved = 2
    hasClicked = True


def move(numChips, gameWindow):
    """
    Get the user's choice for how many chips to take
    """
    global chipsRemoved
    global hasClicked
    buttonSize = 60
    button1 = turtle.Turtle()
    button2 = turtle.Turtle()

    # Display instruction for user
    displayStr = f"Chips: {numChips}\n How many do you take?"
    drawText(displayStr, buttonSize, 30, gameWindow)

    # Draw the buttons with both options
    drawButton(button1, "1", 0 - buttonSize, 0, buttonSize, gameWindow)
    if numChips > 1:
        drawButton(button2, "2", 0 + buttonSize, 0, buttonSize, gameWindow)
    else:
        button2.hideturtle()

    # Wait for user to click on a button
    gameWindow.tracer(True)
    hasClicked = False
    while not hasClicked:
        button1.onclick(removeChips1)
        button2.onclick(removeChips2)
    gameWindow.tracer(False)

    return chipsRemoved
