"""
Created on Jul 16, 2021

@author: YOUR NAME HERE!
"""
import GameGraphics
import random

"""
Using the graphical window:
  GameGraphics.startup() 
    This function requires no input and gives no output.  It sets up the 
    graphical window, and should be called once, at the beginning of the game.
            
  GameGraphics.whose_turn(player_number)
    This function switches the current player to be the one indicated by the 
    input. Its input should be either 1 or 2, and it gives no output.

  GameGraphics.roll(dice1, dice2)
    This function draws the dice to the screen. The two inputs should be 
    integers between 1 and 6 inclusive. There is no return value.
            
  GameGraphics.race(player, score)
    This function causes the turtles to be drawn across the screen to 
    indicate the score and how close the player is to winning. 
    Its input should be two integers: the player number (either 1 or 2) 
    and the score of that player.  It does not return a value.
            
  GameGraphics.reset(player_number)
    This function makes the turtles drawn toward the finish line disappear 
    from the screen. It is used when the player rolls double ones (snake eyes).
    The input is the player to be reset (either 1 or 2).  It does not return a 
    value.

  GameGraphics.ask(round_points, total_score)
    This function causes a pop up window to appear, which tells the player 
    their current point values for both the current round and for the game.  
    It asks the player to type 'r' if they want to roll again and 's' if they 
    want to stop. The inputs are the two score values for the current player, 
    and the output is the letter the user types.
        
  GameGraphics.winner(number) 
    This function prints a winning message.  The input is the number 
    (either 1 or 2) of the winning player.  It returns no output.
        
  GameGraphics.done()
    This function should be called when the game is over, to cleanly close 
    the graphics window.  It uses no input or output.
"""


def play_turn(playerTotalScore):
    """
    This function plays one turn for one player.
    It should let the player roll until they either choose to stop or they roll a one.
    The parameter is the score for the player at the beginning of their turn.

    If they roll a single one, it should return 0.
    If they roll double ones, (snake eyes), it should return -1
    Otherwise, it should return the sum of the rolls.

    Algorithm:
      Start the player with 0 points for the turn.
      Until the player's turn is over:
        Get two random numbers between 1 and 6.
        Draw the result of the rolls to the screen by calling the window's "roll" function.
        React to the roll as follows:
          If the roll contained a single one, the turn is over with no points.
          If the roll was 2 ones, the turn is over, return -1.
          Otherwise, add the roll values to the player's points for this turn and ask to roll again.
      If they never rolled a one, return the points they earned in their turn.
    """
    roundPoints = 0
    rollStop = 'r'
    while rollStop == 'r':
        r1 = random.randint(1, 7)
        r2 = random.randint(1, 7)
        GameGraphics.roll(r1, r2)
        roundPoints = roundPoints + r1 + r2
        if r1 == 1 or r2 == 1:
            return 0
        if r1 == 1 and r2 == 1:
            return -1
        else:
            rollStop = GameGraphics.ask(roundPoints, playerTotalScore)
    return roundPoints


def play_game():
    """
    This function plays the entire game until a player wins.
    It should play each player's turn until one of them reaches 100 points.

    Algorithm:
      Start players with no points
      Until someone reaches 100 points, do the following:
         a) Call the window's "whose_turn" function for player 1.
         b) Call the play_turn function for player 1.
         c) React to the output of the function as follows:
            If they rolled snake eyes, reset their score to 0 and call the
            window's "reset" function
            Otherwise, add the points to the player's score and call the
            window's "race" function
         Repeat steps a - c for Player 2.
      When someone wins, call the window's "winner" function
    """
    player1Score = 0
    player2Score = 0
    while player1Score < 100 or player2Score < 100:
        GameGraphics.whose_turn(1)
        roundScore = play_turn(player1Score)
        if roundScore == -1:
            player1Score = 0
            GameGraphics.reset(1)
        else:
            player1Score = player1Score + roundScore
            GameGraphics.race(1, player1Score)

        GameGraphics.whose_turn(2)
        roundScore = play_turn(player2Score)
        if roundScore == -1:
            player2Score = 0
            GameGraphics.reset(2)
        else:
            player2score = player2Score + roundScore
            GameGraphics.race(2, player2score)

    print("Game over!")
    if player1Score > 99:
        print("Player 1 wins")
        GameGraphics.winner(1)
    else:
        print("Player 2 wins")
        GameGraphics.winner(2)


# Initialize the game window and play the game
GameGraphics.startup()
play_game()
GameGraphics.done()
