"""
Created on Oct 20, 2022

@author: YOUR NAME HERE!!

This module represents a place for practicing writing loops.
"""
import random
import arcade


# Choose a name for your game to appear in the title bar of the game window
GAME_NAME = 'Loops Practice'
# Choose the size of your game window
SCREEN_WIDTH = 1000
SCREEN_HEIGHT = 1000
# Choose number of objects to draw
NUM_OBJECTS = 10
# file containing size and coordinates for shapes
SHAPES_FILE = 'shapes.txt'


class Target(arcade.SpriteCircle):
    """
    This class represents a Sprite that draws itself as a target (rings of alternating colors).
    """
    def __init__(self, x, y, radius):
        # create with radius in pixels and a color
        super().__init__(radius, arcade.color.BLACK)
        # set position to given coordinates
        self.center_x = x
        self.center_y = y

    def draw(self):
        """
        Draw as three rings of alternating colors (BLACK, WHITE, BLACK) by:
        - calling inherited draw first for the outermost ring
        - calling arcade.draw_circle_filled to draw a smaller WHITE circle at the same (center_x, center_y)
        - calling arcade.draw_circle_filled to draw an even smaller BLACK circle at the same (center_x, center_y)
        """
        super().draw()
        # TODO: draw the target's two smaller rings


class Game(arcade.Window):
    """
    This class represents the entire game:
    - setting up any objects to appear in game
    - updating their values (in method on_update)
    - drawing them (in method on_draw)
    - responding to key input (in method on_key_press)
    - responding to mouse input (in method on_mouse_press)
    """
    def __init__(self):
        # create with size (width, height) and a title
        super().__init__(SCREEN_WIDTH, SCREEN_HEIGHT, GAME_NAME)
        arcade.set_background_color(arcade.color.LIGHT_BLUE)
        # start with an empty list of game objects to be filled in by loop methods
        self.shapes = []

    def reset(self):
        """
        Clear the list of shapes to prepare for new shapes to be added
        """
        self.shapes = []

    def on_key_press(self, key, modifiers):
        """
        Called whenever a key is pressed.
        """
        # any key press "erases the screen"
        self.reset()
        # number keys call your code to fill shapes list with new Sprites
        if key == arcade.key.KEY_1:
            self.horizontal_row_of_circles(NUM_OBJECTS)
        if key == arcade.key.KEY_2:
            self.different_colors(NUM_OBJECTS)
        if key == arcade.key.KEY_3:
            self.alternating_shapes(NUM_OBJECTS)
        if key == arcade.key.KEY_4:
            self.vertical_row_of_targets(NUM_OBJECTS)
        if key == arcade.key.KEY_5:
            self.read_from_file(SHAPES_FILE)

    def on_draw(self):
        """
        Render all the game objects on the screen.
        """
        # DO NOT CHANGE -- always clear the screen as the FIRST step
        self.clear()
        # now draw your game objects
        for shape in self.shapes:
            shape.draw()

    def on_update(self, dt):
        """
        NO UPDATES NEEDED
        """
        pass

    def horizontal_row_of_circles(self, numShapes):
        """
        Create the given number of Circle Sprites in a horizontal row across the center of the screen.
        """
        arcade.set_background_color(arcade.color.DANDELION)
        # TODO: write a loop to create the given number of Sprites in the described pattern

    def different_colors(self, numShapes):
        """
        Create the given number of Circle Sprites at random locations cycling through the different colors in the list.
        Note, if there are more shapes than colors then reuse the colors by starting over with the first color.
        """
        colors = [ arcade.color.BLACK, arcade.color.WHITE, arcade.color.PALE_AQUA, arcade.color.YELLOW_ROSE, arcade.color.OCHRE ]
        arcade.set_background_color(arcade.color.LAVA)
        # TODO: write a loop to create the given number of Sprites in the described pattern

    def alternating_shapes(self, numShapes):
        """
        Create the given number of Sprites in a diagonal row across the screen alternating between Circles and Squares.
        """
        arcade.set_background_color(arcade.color.LION)
        # TODO: write a loop to create the given number of Sprites in the described pattern

    def vertical_row_of_targets(self, numShapes):
        """
        Create the given number of Target sprites in a vertical row down the center of the screen.
        """
        arcade.set_background_color(arcade.color.HELIOTROPE)
        # TODO: write a loop to create the given number of Sprites in the described pattern

    def read_from_file(self, fileName):
        """
        Create a number of Circle Sprites whose radius and position will be given in a file.
        Note, each line of the file will have 3 numbers, representing a single circle's size, x, and y
        Note, you can get the individual values by calling the String's split() method that returns a list
        Note, you can convert each string value in the list to an int using int(list_data[index])
        """
        arcade.set_background_color(arcade.color.LIGHT_ORCHID)
        # TODO: write a loop to create a Sprites for each line in the given file


# Create the game and set initial scene
game = Game()
# Play the game forever
arcade.run()
