"""
Created on Oct 31, 2022

@author: YOUR NAME HERE!!

This module represents a place for practicing writing nested loops.
"""
import arcade


# Choose a name for your game to appear in the title bar of the game window
GAME_NAME = 'Nested Loops Practice'
# Choose the size of your game window
SCREEN_WIDTH = 800
SCREEN_HEIGHT = 800
# Choose number of objects to draw
NUM_ROWS = 10
NUM_COLS = 10


class Game(arcade.Window):
    """
    This class represents the entire game:
    - setting up any objects to appear in game
    - updating their values (in method on_update)
    - drawing them (in method on_draw)
    - responding to key input (in method on_key_press)
    - responding to mouse input (in method on_mouse_press)
    """
    def __init__(self):
        # create with size (width, height) and a title
        super().__init__(SCREEN_WIDTH, SCREEN_HEIGHT, GAME_NAME)
        arcade.set_background_color(arcade.color.LIGHT_BLUE)
        # start with an empty list of game objects to be filled in by loop methods
        self.shapes = []

    def reset(self):
        """
        Clear the list of shapes to prepare for new shapes to be added
        """
        self.shapes = []

    def on_key_press(self, key, modifiers):
        """
        Called whenever a key is pressed.
        """
        # any key press "erases the screen"
        self.reset()
        # number keys call your code to fill shapes list with new Sprites
        if key == arcade.key.KEY_1:
            self.full_grid(NUM_ROWS, NUM_COLS)
        if key == arcade.key.KEY_2:
            self.left_diagonal(NUM_ROWS, NUM_COLS)
        if key == arcade.key.KEY_3:
            self.right_diagonal(NUM_ROWS, NUM_COLS)
        if key == arcade.key.KEY_4:
            self.pyramid(NUM_ROWS, NUM_COLS)

    def on_draw(self):
        """
        Render all the game objects on the screen.
        """
        # DO NOT CHANGE -- always clear the screen as the FIRST step
        self.clear()
        # now draw your game objects
        for shape in self.shapes:
            shape.draw()

    def on_update(self, dt):
        """
        NO UPDATES NEEDED
        """
        pass

    def full_grid(self, numRows, numColumns):
        """
        Create a full grid of evenly spaced circle Sprites that has the given number of rows and columns
        """
        arcade.set_background_color(arcade.color.DANDELION)
        # these circles will be smaller than the last set of exercises, so the circle's radius will be half this size
        size = min(SCREEN_WIDTH // (numColumns * 2), SCREEN_HEIGHT // (numRows * 2))

    def left_diagonal(self, numRows, numColumns):
        """
        Create a number of circle Sprites such that the first row in the bottom LEFT corner has only one circle,
        then two, then three (positioned to the right), up to a complete row containing the given number of columns
        along the screen's top.
        """
        arcade.set_background_color(arcade.color.LION)
        # these circles will be smaller than the last set of exercises, so the circle's radius will be half this size
        size = min(SCREEN_WIDTH // (numColumns * 2), SCREEN_HEIGHT // (numRows * 2))

    def right_diagonal(self, numRows, numColumns):
        """
        Create a number of circle Sprites such that the first row in the bottom RIGHT corner has only one circle,
        then two, then three (positioned to the left), up to a complete row containing the given number of columns
        along the screen's top.
        """
        arcade.set_background_color(arcade.color.LAVA)
        # these circles will be smaller than the last set of exercises, so the circle's radius will be half this size
        size = min(SCREEN_WIDTH // (numColumns * 2), SCREEN_HEIGHT // (numRows * 2))

    def pyramid(self, numRows, numColumns):
        """
        Create a number of circle Sprites such that the first row in the top center has only one circle, then a row of
        two evenly spaced circles on either side (i.e., offset from center by -0.5 and +0.5), then three (i.e., offset
        from center by -1, 0, and +1), up to a complete row containing the given number of columns along the screen's
        bottom.
        """
        arcade.set_background_color(arcade.color.HELIOTROPE)
        # these circles will be smaller than the last set of exercises, so the circle's radius will be half this size
        size = min(SCREEN_WIDTH // (numColumns * 2), SCREEN_HEIGHT // (numRows * 2))


# Create the game and set initial scene
game = Game()
# Play the game forever
arcade.run()
