package WatorWorld;

import java.util.ArrayList;
import java.util.Collections;
import java.awt.Color;

/**
 * A class to model a Fish in the Wator simulation.
 */
public class Fish extends Actor {
    
    // number of turns befure a fish can breed
    private static int breedTime = 4;
    
    // track the number of fish alive in the simulation
    private static int numFish = 0;
    
    // how long before fish can breed
    private int turnsUntilCanBreed;
    
    /**
     * Change the number of turns before a fish
     * can breed.
     * @param newBreedTime parmater must be greater than 0.
     */
    public static void setBreedTime(int newBreedTime){
        breedTime = newBreedTime;
    }
    
    /**
     * Return the total number of fish that exist.
     * @return The total number of fish that exist.
     */
    public static int getNumFish(){
        return numFish;
    }
    
    /**
     * Reset number of fish to zero.
     */
    public static void resetNumFish(){
        numFish = 0;
    }   
    
    /**
     * Get the standard Fish Color.
     * @return The standard Color for Fish.
     */
    public static Color getStandardFishColor() {
        return Color.GREEN;
    }
    
    public static int getBreedTime() {
        return breedTime;
    }
    
    /**
     * Create a new Fish. Increment the total number of fish.
     */
    public Fish(){
        super();
        setColor(getStandardFishColor());
        turnsUntilCanBreed = breedTime + (int) (Math.random() * 3);
        numFish++;
    }
    
    /**
     * Act to move if possible and then breed if time.
     * Fish act by first checking to see if they can
     * move. If they can they move to a random location.
     * Then they check to see if it is time to breed.
     * If so then they create an offspring in the
     * location they just left.
     */
    public void act(){
        turnsUntilCanBreed--;
        ArrayList<Location> openSpots = getGrid().getEmptyAdjacentLocations(getLocation());
        if(openSpots.size() > 0){
            Location oldLocation = getLocation();
            Collections.shuffle(openSpots);
            moveTo(openSpots.get(0));
            if(turnsUntilCanBreed <= 0){
                Fish newFish = new Fish();
                newFish.putSelfInGrid(getGrid(), oldLocation);
                turnsUntilCanBreed = breedTime;
            }
        }
    }
    
    /**
     * Return the character for Fish.
     */
    public char getChar(){
        return 'F';
    }
    
    /**
     * Remove my self from the grid and decrement the
     * total number of fish.
     */
    public void removeSelfFromGrid(){
        super.removeSelfFromGrid();
        numFish--;
    }
    
    /**
     * Return if edible, which for fish is true.
     */
    public boolean isEdible(){
        return true;
    }
}

