package WatorWorld;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WatorFrame{
    
    private static final int MIN_FRAMES_PER_SECOND = 10;
    private static final int MAX_FRAMES_PER_SECOND = 50;
    private static final int DEFAULT_FRAMES_PER_SECOND = 30;
    
    private JFrame frame;
    private WatorPanel watorPanel;
    private GraphPanel graphPanel;
    private Timer timer; 
    
    public WatorFrame() {
        //  set up frame 
        frame = new JFrame();
        frame.setTitle("Wator World - Predator Prey Simulation");
        frame.setSize(400, 400);
        frame.setLocation(25, 0);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        
        // rows, columns, fraction fish, fraction sharks
        watorPanel = new WatorPanel(34, 51, 0.7, 0.1); 
        frame.add(watorPanel);
        graphPanel = new GraphPanel(watorPanel.getWorld());
        frame.add(graphPanel, "North");
        addTimer();
        addControlPanel();
        
        frame.setResizable(false);
        frame.pack();
    }
    
    // post: create and add a slider to control time delay
    // based on code from Stuart Reges at UWCS
    
    // Add all the controls for the GUI.
    // Add a slider, and buttons to start and stop
    // the simulation. Add a button to reset the
    // simulation.
    // ** VERY IMPORTANT for CS324e students.**
    // For the assignement add one other control.
    // You choose what the control does.
    private void addControlPanel() {
        // slider to control frames per second
        final JSlider slider = new JSlider(MIN_FRAMES_PER_SECOND, MAX_FRAMES_PER_SECOND);
        slider.addChangeListener(new ChangeListener() {
            public void stateChanged(ChangeEvent e) {
                timer.setDelay(1000 / slider.getValue());
            } });

        slider.setValue(DEFAULT_FRAMES_PER_SECOND);
        
        //  create a panel for the slider and its slow/fast labels 
        JPanel controlPanel = new JPanel();
        controlPanel.setPreferredSize(new Dimension(watorPanel.getWidth(), 40));
        controlPanel.add(new JLabel("slow"));
        controlPanel.add(slider);
        controlPanel.add(new JLabel("fast"));
       
        // *** CS324e Students. Add code here or a call to a helper method you
        // write to add the Start, Stop, and Reset buttons. ***
        
        frame.add(controlPanel, "South");
    }    
    
    // post: Timer created
    private void addTimer(){
        timer = new Timer((int) (1000.0 / DEFAULT_FRAMES_PER_SECOND), 
                new ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                // CS324e students: Add code here to perform
                // necessary actions when Time goes off.
                // That means telling the watorPanel and graphPanel
                // objects to update themselves.
            } });
        
        timer.setCoalesce(true); 
    }
     
    public void start(){
        frame.setVisible(true);
        watorPanel.repaint();
        graphPanel.repaint();
    }
}