/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.AbstractGrid;
import A4.Location;
import java.util.ArrayList;

public class BoundedGrid<E>
extends AbstractGrid<E> {
    private Object[][] occupantArray;

    public BoundedGrid(int rows, int cols) {
        if (rows <= 0) {
            throw new IllegalArgumentException("rows <= 0");
        }
        if (cols <= 0) {
            throw new IllegalArgumentException("cols <= 0");
        }
        this.occupantArray = new Object[rows][cols];
    }

    @Override
    public int getNumRows() {
        return this.occupantArray.length;
    }

    @Override
    public int getNumCols() {
        return this.occupantArray[0].length;
    }

    @Override
    public boolean isValid(Location loc) {
        return loc.getRow() >= 0 && loc.getRow() < this.getNumRows() && loc.getCol() >= 0 && loc.getCol() < this.getNumCols();
    }

    @Override
    public ArrayList<Location> getOccupiedLocations() {
        ArrayList<Location> theLocations = new ArrayList<Location>();
        int r = 0;
        while (r < this.getNumRows()) {
            int c = 0;
            while (c < this.getNumCols()) {
                Location loc = new Location(r, c);
                if (this.get(loc) != null) {
                    theLocations.add(loc);
                }
                ++c;
            }
            ++r;
        }
        return theLocations;
    }

    @Override
    public E get(Location loc) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        return (E)this.occupantArray[loc.getRow()][loc.getCol()];
    }

    @Override
    public E put(Location loc, E obj) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        if (obj == null) {
            throw new NullPointerException("obj == null");
        }
        E oldOccupant = this.get(loc);
        this.occupantArray[loc.getRow()][loc.getCol()] = obj;
        return oldOccupant;
    }

    @Override
    public E remove(Location loc) {
        if (!this.isValid(loc)) {
            throw new IllegalArgumentException("Location " + loc + " is not valid");
        }
        E r = this.get(loc);
        this.occupantArray[loc.getRow()][loc.getCol()] = null;
        return r;
    }
}

