/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.Actor;
import A4.Location;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;

public class Fish
extends Actor {
    private static int breedTime = 4;
    private static int numFish = 0;
    private int turnsUntilCanBreed;

    public static void setBreedTime(int newBreedTime) {
        breedTime = newBreedTime;
    }

    public static int getNumFish() {
        return numFish;
    }

    public static void resetNumFish() {
        numFish = 0;
    }

    public static Color getStandardFishColor() {
        return Color.GREEN;
    }

    public static int getBreedTime() {
        return breedTime;
    }

    public Fish() {
        this.setColor(Fish.getStandardFishColor());
        this.turnsUntilCanBreed = breedTime + (int)(Math.random() * 3.0);
        ++numFish;
    }

    @Override
    public void act() {
        --this.turnsUntilCanBreed;
        ArrayList<Location> openSpots = this.getGrid().getEmptyAdjacentLocations(this.getLocation());
        if (openSpots.size() > 0) {
            Location oldLocation = this.getLocation();
            Collections.shuffle(openSpots);
            this.moveTo(openSpots.get(0));
            if (this.turnsUntilCanBreed <= 0) {
                Fish newFish = new Fish();
                newFish.putSelfInGrid(this.getGrid(), oldLocation);
                this.turnsUntilCanBreed = breedTime;
            }
        }
    }

    @Override
    public char getChar() {
        return 'F';
    }

    @Override
    public void removeSelfFromGrid() {
        super.removeSelfFromGrid();
        --numFish;
    }

    @Override
    public boolean isEdible() {
        return true;
    }
}

