/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.Fish;
import A4.Shark;
import A4.WatorWorld;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel {
    private final int HEIGHT = 150;
    private final int SCALE_UP_CUTOFF = 8;
    private final String REMINDER = "Sharks Scaled 8X";
    private final Font FONT_FOR_SCALED_MESSAGE;
    private double scaleFactor;
    private double numSpotsCutoffToScaleUp;
    private Image doubleBufferImage;
    private Rectangle2D.Double background;
    private ArrayList<Integer> numFish;
    private ArrayList<Integer> numSharks;
    private WatorWorld theWorld;

    public GraphPanel(WatorWorld w) {
        this.setBackground(Color.WHITE);
        this.numFish = new ArrayList();
        this.numSharks = new ArrayList();
        this.resetParameters(w);
        Dimension dim = new Dimension(750, 150);
        this.setPreferredSize(dim);
        this.background = new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
        this.FONT_FOR_SCALED_MESSAGE = new Font("Serif", 1, 20);
    }

    public void reset(WatorWorld w) {
        this.numFish.clear();
        this.numSharks.clear();
        this.resetParameters(w);
        this.render();
    }

    private void resetParameters(WatorWorld w) {
        this.theWorld = w;
        this.numFish.add(this.theWorld.getNumFish());
        this.numSharks.add(this.theWorld.getNumSharks());
        this.scaleFactor = 149.0 / (double)this.theWorld.getNumSpots();
        this.numSpotsCutoffToScaleUp = this.theWorld.getNumSpots() / 8;
    }

    public void update() {
        this.numFish.add(this.theWorld.getNumFish());
        this.numSharks.add(this.theWorld.getNumSharks());
        this.render();
        if (this.numFish.size() >= this.getWidth()) {
            this.numFish.clear();
            this.numSharks.clear();
        }
    }

    private void render() {
        if (this.doubleBufferImage == null) {
            this.doubleBufferImage = this.createImage((int)this.background.width, (int)this.background.height);
        }
        Graphics2D dbg = (Graphics2D)this.doubleBufferImage.getGraphics();
        dbg.setColor(Color.WHITE);
        dbg.fill(this.background);
        dbg.translate(0, this.getHeight());
        dbg.setStroke(new BasicStroke(2.0f));
        dbg.setColor(Fish.getStandardFishColor());
        this.plot(this.numFish, dbg, this.scaleFactor);
        dbg.setColor(Shark.getStandardSharkColor());
        if (this.scaleSharks()) {
            this.drawReminder(dbg);
            this.plot(this.numSharks, dbg, this.scaleFactor * 8.0);
        } else {
            this.plot(this.numSharks, dbg, this.scaleFactor);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.doubleBufferImage == null) {
            this.render();
        }
        g.drawImage(this.doubleBufferImage, 0, 0, null);
    }

    private void drawReminder(Graphics2D g2) {
        g2.setFont(this.FONT_FOR_SCALED_MESSAGE);
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = this.FONT_FOR_SCALED_MESSAGE.getStringBounds("Sharks Scaled 8X", context);
        g2.drawString("Sharks Scaled 8X", 5, -((int)bounds.getHeight()));
    }

    public boolean scaleSharks() {
        for (int sharks : this.numSharks) {
            if (!((double)sharks > this.numSpotsCutoffToScaleUp)) continue;
            return false;
        }
        return true;
    }

    private void plot(ArrayList<Integer> values, Graphics2D g2, double scaleFactor) {
        if (values.size() > 0) {
            double y = (double)(-values.get(0).intValue()) * scaleFactor;
            g2.fill(new Rectangle2D.Double(0.0, y, 2.0, 2.0));
        }
        int i = 1;
        while (i < values.size()) {
            double y1 = (double)(-values.get(i - 1).intValue()) * scaleFactor;
            double y2 = (double)(-values.get(i).intValue()) * scaleFactor;
            g2.draw(new Line2D.Double(i - 1, y1, i, y2));
            ++i;
        }
    }
}

