/*
 * Decompiled with CFR 0.152.
 */
package A4;

public class Location
implements Comparable<Location> {
    private int row;
    private int col;
    public static final int LEFT = -90;
    public static final int RIGHT = 90;
    public static final int HALF_LEFT = -45;
    public static final int HALF_RIGHT = 45;
    public static final int FULL_CIRCLE = 360;
    public static final int HALF_CIRCLE = 180;
    public static final int AHEAD = 0;
    public static final int NORTH = 0;
    public static final int NORTHEAST = 45;
    public static final int EAST = 90;
    public static final int SOUTHEAST = 135;
    public static final int SOUTH = 180;
    public static final int SOUTHWEST = 225;
    public static final int WEST = 270;
    public static final int NORTHWEST = 315;

    public Location(int r, int c) {
        this.row = r;
        this.col = c;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public Location getAdjacentLocation(int direction) {
        int adjustedDirection = (direction + 22) % 360;
        if (adjustedDirection < 0) {
            adjustedDirection += 360;
        }
        adjustedDirection = adjustedDirection / 45 * 45;
        int dc = 0;
        int dr = 0;
        if (adjustedDirection == 90) {
            dc = 1;
        } else if (adjustedDirection == 135) {
            dc = 1;
            dr = 1;
        } else if (adjustedDirection == 180) {
            dr = 1;
        } else if (adjustedDirection == 225) {
            dc = -1;
            dr = 1;
        } else if (adjustedDirection == 270) {
            dc = -1;
        } else if (adjustedDirection == 315) {
            dc = -1;
            dr = -1;
        } else if (adjustedDirection == 0) {
            dr = -1;
        } else if (adjustedDirection == 45) {
            dc = 1;
            dr = -1;
        }
        return new Location(this.getRow() + dr, this.getCol() + dc);
    }

    public int getDirectionToward(Location target) {
        int dx = target.getCol() - this.getCol();
        int dy = target.getRow() - this.getRow();
        int angle = (int)Math.toDegrees(Math.atan2(-dy, dx));
        int compassAngle = 90 - angle;
        if ((compassAngle += 22) < 0) {
            compassAngle += 360;
        }
        return compassAngle / 45 * 45;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Location)) {
            return false;
        }
        Location otherLoc = (Location)other;
        return this.getRow() == otherLoc.getRow() && this.getCol() == otherLoc.getCol();
    }

    public int hashCode() {
        return this.getRow() * 3737 + this.getCol();
    }

    @Override
    public int compareTo(Location other) {
        Location otherLoc = other;
        if (this.getRow() < otherLoc.getRow()) {
            return -1;
        }
        if (this.getRow() > otherLoc.getRow()) {
            return 1;
        }
        if (this.getCol() < otherLoc.getCol()) {
            return -1;
        }
        if (this.getCol() > otherLoc.getCol()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "(" + this.getRow() + ", " + this.getCol() + ")";
    }
}

