/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.Actor;
import A4.Fish;
import A4.Location;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class Shark
extends Actor {
    private static int standardBreedTime = 20;
    private static int standardStarveTime = 5;
    private static int numSharks = 0;
    private static Random rand = new Random();
    private int turnsSinceLastAte = 0;
    private int turnsUntilCanBreed = standardBreedTime;
    private int myBreedTime;
    private int myStarveTime;

    public static int getNumSharks() {
        return numSharks;
    }

    public static void resetNumSharks() {
        numSharks = 0;
    }

    public static void setBreedTime(int newBreedTime) {
        standardBreedTime = newBreedTime;
    }

    public static void setStarveTime(int newStarveTime) {
        standardStarveTime = newStarveTime;
    }

    public static int getStarveTime() {
        return standardStarveTime;
    }

    public static int getBreedTime() {
        return standardBreedTime;
    }

    public static Color getStandardSharkColor() {
        return Color.ORANGE;
    }

    public Shark() {
        this.setColor(Shark.getStandardSharkColor());
        this.myBreedTime = standardBreedTime + rand.nextInt(10);
        this.myStarveTime = standardStarveTime + rand.nextInt(5);
        ++numSharks;
    }

    @Override
    public void act() {
        --this.turnsUntilCanBreed;
        ++this.turnsSinceLastAte;
        boolean stillAlive = this.iDidNotStarve();
        if (stillAlive && !this.ate()) {
            this.tryMove();
        }
        if (stillAlive) {
            this.attemptToBreed();
        }
    }

    private void attemptToBreed() {
        ArrayList<Location> openSpots;
        if (this.turnsUntilCanBreed <= 0 && (openSpots = this.getGrid().getEmptyAdjacentLocations(this.getLocation())).size() > 0) {
            Collections.shuffle(openSpots);
            Shark newShark = new Shark();
            newShark.putSelfInGrid(this.getGrid(), openSpots.get(0));
            this.turnsUntilCanBreed = this.myBreedTime;
        }
    }

    private boolean iDidNotStarve() {
        boolean result = true;
        if (this.turnsSinceLastAte == this.myStarveTime) {
            this.removeSelfFromGrid();
            --numSharks;
            result = false;
        }
        return result;
    }

    private void tryMove() {
        ArrayList<Location> openSpots = this.getGrid().getEmptyAdjacentLocations(this.getLocation());
        if (openSpots.size() > 0) {
            Collections.shuffle(openSpots);
            this.moveTo(openSpots.get(0));
        }
    }

    private boolean ate() {
        ArrayList<Location> neighbors = this.getGrid().getOccupiedAdjacentLocations(this.getLocation());
        Collections.shuffle(neighbors);
        boolean eaten = false;
        int index = 0;
        while (!eaten && index < neighbors.size()) {
            Actor possibleFood = this.getGrid().get(neighbors.get(index));
            if (possibleFood instanceof Fish) {
                eaten = true;
                this.turnsSinceLastAte = 0;
                possibleFood.removeSelfFromGrid();
            }
            ++index;
        }
        return eaten;
    }

    @Override
    public char getChar() {
        return 'S';
    }
}

