/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.Fish;
import A4.GraphPanel;
import A4.Shark;
import A4.WatorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class WatorFrame {
    private static final int TIMER_DEFAULT_DELAY = 33;
    private static final int MIN_FRAMES_PER_SECOND = 10;
    private static final int MAX_FRAMES_PER_SECOND = 50;
    private JFrame frame = new JFrame();
    private WatorPanel watorPanel;
    private GraphPanel graphPanel;
    private Timer timer;
    private double fractionFish;
    private double fractionSharks;
    private int worldRows;
    private int worldCols;

    public WatorFrame(boolean advanced) {
        this.frame.setTitle("Wator World - Predator Prey Simulation");
        this.frame.setSize(400, 400);
        this.frame.setLocation(25, 0);
        this.frame.setDefaultCloseOperation(3);
        this.createWorldAndPanel();
        this.graphPanel = new GraphPanel(this.watorPanel.getWorld());
        this.frame.add((Component)this.graphPanel, "North");
        this.addTimer();
        this.addControlPanel(advanced);
        this.frame.setResizable(false);
        this.frame.pack();
    }

    private void createWorldAndPanel() {
        this.fractionFish = 0.7;
        this.fractionSharks = 0.1;
        this.worldRows = 34;
        this.worldCols = 50;
        this.watorPanel = new WatorPanel(34, 50, this.fractionFish, this.fractionSharks);
        this.frame.add(this.watorPanel);
    }

    private void addControlPanel(boolean advanced) {
        final JSlider slider = new JSlider(10, 50);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WatorFrame.this.timer.setDelay(1000 / slider.getValue());
            }
        });
        slider.setValue(30);
        slider.setPreferredSize(new Dimension(120, 20));
        JPanel controlPanel = new JPanel();
        controlPanel.setPreferredSize(new Dimension((int)this.watorPanel.getPreferredSize().getWidth(), 70));
        controlPanel.add(new JLabel("slow"));
        controlPanel.add(slider);
        controlPanel.add(new JLabel("fast"));
        this.addButtons(controlPanel);
        if (advanced) {
            this.addSizeControls(controlPanel);
            controlPanel.add((Component)this.getSpinnerPanel(), "South");
        }
        this.frame.add((Component)controlPanel, "South");
    }

    private void addSizeControls(JPanel controlPanel) {
        controlPanel.add(new JLabel("rows"));
        final JSpinner rows = new JSpinner(new SpinnerNumberModel(this.worldRows, 10, 400, 10));
        controlPanel.add(rows);
        rows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WatorFrame.this.worldRows = (Integer)rows.getValue();
            }
        });
        controlPanel.add(new JLabel("cols"));
        final JSpinner cols = new JSpinner(new SpinnerNumberModel(this.worldCols, 10, 400, 10));
        controlPanel.add(cols);
        cols.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WatorFrame.this.worldCols = (Integer)cols.getValue();
            }
        });
    }

    private JPanel getSpinnerPanel() {
        JPanel spinnerPanel = new JPanel();
        spinnerPanel.setPreferredSize(new Dimension((int)this.watorPanel.getPreferredSize().getWidth(), 30));
        this.addCreatureControls(spinnerPanel);
        this.addPercentCreatureControls(spinnerPanel);
        return spinnerPanel;
    }

    private void addPercentCreatureControls(JPanel spinnerPanel) {
        spinnerPanel.add(new JLabel("% Fish"));
        final JSpinner percentFish = new JSpinner(new SpinnerNumberModel((int)(this.fractionFish * 100.0), 5, 95, 5));
        spinnerPanel.add(percentFish);
        spinnerPanel.add(new JLabel("% Shark"));
        final JSpinner percentSharks = new JSpinner(new SpinnerNumberModel((int)(this.fractionSharks * 100.0), 5, 95, 5));
        spinnerPanel.add(percentSharks);
        percentFish.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WatorFrame.this.fractionFish = (double)((Integer)percentFish.getValue()).intValue() / 100.0;
                if (WatorFrame.this.fractionFish + WatorFrame.this.fractionSharks > 1.0) {
                    WatorFrame.this.fractionSharks = 1.0 - WatorFrame.this.fractionFish;
                    percentSharks.setValue((int)(WatorFrame.this.fractionSharks * 100.0));
                }
            }
        });
        percentSharks.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WatorFrame.this.fractionSharks = (double)((Integer)percentSharks.getValue()).intValue() / 100.0;
                if (WatorFrame.this.fractionFish + WatorFrame.this.fractionSharks > 1.0) {
                    WatorFrame.this.fractionFish = 1.0 - WatorFrame.this.fractionSharks;
                    percentFish.setValue((int)(WatorFrame.this.fractionFish * 100.0));
                }
            }
        });
    }

    private void addCreatureControls(JPanel spinnerPanel) {
        spinnerPanel.add(new JLabel("fish breed"));
        final JSpinner fishBreed = new JSpinner(new SpinnerNumberModel(Fish.getBreedTime(), 1, 30, 1));
        fishBreed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Fish.setBreedTime((Integer)fishBreed.getValue());
            }
        });
        spinnerPanel.add(fishBreed);
        spinnerPanel.add(new JLabel("shark starve"));
        final JSpinner sharkStarve = new JSpinner(new SpinnerNumberModel(Shark.getStarveTime(), 2, 50, 1));
        sharkStarve.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Shark.setStarveTime((Integer)sharkStarve.getValue());
            }
        });
        spinnerPanel.add(sharkStarve);
        spinnerPanel.add(new JLabel("shark breed"));
        final JSpinner sharkBreed = new JSpinner(new SpinnerNumberModel(Shark.getBreedTime(), 2, 50, 1));
        sharkBreed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Shark.setBreedTime((Integer)sharkBreed.getValue());
            }
        });
        spinnerPanel.add(sharkBreed);
    }

    private void addButtons(JPanel controlPanel) {
        JButton step = new JButton("Step");
        step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatorFrame.this.timer.stop();
                WatorFrame.this.performStep();
            }
        });
        controlPanel.add(step);
        JButton start = new JButton("Start");
        start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatorFrame.this.timer.start();
            }
        });
        controlPanel.add(start);
        JButton stop = new JButton("Stop");
        stop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatorFrame.this.timer.stop();
            }
        });
        controlPanel.add(stop);
        JButton reset = new JButton("Reset");
        reset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatorFrame.this.timer.stop();
                WatorFrame.this.watorPanel.reset(WatorFrame.this.worldRows, WatorFrame.this.worldCols, WatorFrame.this.fractionFish, WatorFrame.this.fractionSharks);
                WatorFrame.this.graphPanel.reset(WatorFrame.this.watorPanel.getWorld());
                WatorFrame.this.frame.repaint();
            }
        });
        controlPanel.add(reset);
    }

    private void addTimer() {
        this.timer = new Timer(33, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WatorFrame.this.performStep();
            }
        });
        this.timer.setCoalesce(true);
    }

    public void start() {
        this.frame.setVisible(true);
    }

    private void performStep() {
        this.watorPanel.update();
        this.graphPanel.update();
        this.frame.repaint();
    }
}

