/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.WatorWorld;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JPanel;

class WatorPanel
extends JPanel {
    public static final int P_WIDTH = 750;
    public static final int P_HEIGHT = 500;
    private static final int ELLIPSE_CUTOFF = 2500;
    private Image doubleBufferImage;
    private Rectangle2D.Double background;
    private WatorWorld theWorld;

    public WatorPanel(int rows, int cols, double fractionFish, double fractionSharks) {
        this.setBackground(Color.BLUE);
        this.setPreferredSize(new Dimension(750, 500));
        this.background = new Rectangle2D.Double(0.0, 0.0, 750.0, 500.0);
        this.theWorld = new WatorWorld(rows, cols, fractionFish, fractionSharks);
    }

    public void reset(int rows, int cols, double fractionFish, double fractionSharks) {
        this.theWorld = new WatorWorld(rows, cols, fractionFish, fractionSharks);
        this.render();
    }

    public void update() {
        this.theWorld.step();
        this.render();
    }

    private void render() {
        if (this.doubleBufferImage == null) {
            this.doubleBufferImage = this.createImage((int)this.background.width, (int)this.background.height);
        }
        Graphics2D dbg = (Graphics2D)this.doubleBufferImage.getGraphics();
        dbg.setColor(WatorWorld.getOceanColor());
        dbg.fill(this.background);
        double cellWidth = 750.0 / (double)this.theWorld.getNumCols();
        double cellHeight = 500.0 / (double)this.theWorld.getNumRows();
        RectangularShape sh = this.theWorld.getNumSpots() < 2500 ? new Ellipse2D.Double(0.0, 0.0, cellWidth, cellHeight) : new Rectangle2D.Double(0.0, 0.0, cellWidth, cellHeight);
        int r = 0;
        while (r < this.theWorld.getNumRows()) {
            int c = 0;
            while (c < this.theWorld.getNumCols()) {
                Color col = this.theWorld.getColor(r, c);
                if (col != Color.BLUE) {
                    dbg.setColor(col);
                    sh.setFrame((double)c * cellWidth, (double)r * cellHeight, cellWidth, cellHeight);
                    dbg.fill(sh);
                }
                ++c;
            }
            ++r;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.doubleBufferImage == null) {
            this.render();
        }
        g.drawImage(this.doubleBufferImage, 0, 0, null);
    }

    public WatorWorld getWorld() {
        return this.theWorld;
    }
}

