/*
 * Decompiled with CFR 0.152.
 */
package A4;

import A4.Actor;
import A4.Fish;
import A4.Grid;
import A4.Location;
import A4.Shark;
import A4.WrappedBoundedGrid;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class WatorWorld {
    private Grid<Actor> theWorld;
    private static Color oceanColor = new Color(50, 50, 255);

    public static Color getOceanColor() {
        return oceanColor;
    }

    public WatorWorld(int rows, int cols, double fractionFish, double fractionSharks) {
        this.theWorld = new WrappedBoundedGrid<Actor>(rows, cols);
        this.reset(fractionFish, fractionSharks);
    }

    public void reset(double fractionFish, double fractionSharks) {
        ArrayList<Location> occupiedCells = this.theWorld.getOccupiedLocations();
        for (Location loc : occupiedCells) {
            this.theWorld.get(loc).removeSelfFromGrid();
        }
        Shark.resetNumSharks();
        Fish.resetNumFish();
        this.populateWorld(fractionFish, fractionSharks);
    }

    private void populateWorld(double fractionFish, double fractionSharks) {
        int numSharks;
        int numFish;
        double totalFractionCreatures = fractionFish + fractionSharks;
        if (totalFractionCreatures > 1.0) {
            fractionFish /= totalFractionCreatures;
            fractionSharks /= totalFractionCreatures;
        }
        if ((numFish = (int)(fractionFish * (double)this.getNumSpots())) + (numSharks = (int)(fractionSharks * (double)this.getNumSpots())) < this.getNumSpots() / 2) {
            this.populateDefinite(numFish, numSharks);
        } else {
            this.populateIndefinite(numFish, numSharks);
        }
    }

    private void populateIndefinite(int numFish, int numSharks) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int r = 0;
        int rLimit = this.theWorld.getNumRows();
        while (r < rLimit) {
            int c = 0;
            int cLimit = this.theWorld.getNumCols();
            while (c < cLimit) {
                locs.add(new Location(r, c));
                ++c;
            }
            ++r;
        }
        Collections.shuffle(locs);
        int i = 0;
        while (i < numFish) {
            new Fish().putSelfInGrid(this.theWorld, (Location)locs.get(i));
            ++i;
        }
        i = numFish;
        int limit = numFish + numSharks;
        while (i < limit) {
            new Shark().putSelfInGrid(this.theWorld, (Location)locs.get(i));
            ++i;
        }
    }

    private void populateDefinite(int numFish, int numSharks) {
        this.loopToPlace(numFish, true);
        this.loopToPlace(numSharks, false);
    }

    private void loopToPlace(int num, boolean placeFish) {
        int placed = 0;
        Random r = new Random();
        ArrayList<Location> locsUsed = new ArrayList<Location>();
        while (placed < num) {
            int col;
            int row = r.nextInt(this.theWorld.getNumRows());
            Location loc = new Location(row, col = r.nextInt(this.theWorld.getNumCols()));
            if (this.theWorld.get(loc) != null) continue;
            ++placed;
            Actor result = placeFish ? new Fish() : new Shark();
            result.putSelfInGrid(this.theWorld, loc);
            locsUsed.add(loc);
        }
    }

    public void step() {
        ArrayList<Location> occupiedLocations = this.theWorld.getOccupiedLocations();
        Collections.shuffle(occupiedLocations);
        for (Location loc : occupiedLocations) {
            Actor a = this.theWorld.get(loc);
            if (a == null) continue;
            a.act();
        }
    }

    public int getNumFish() {
        return Fish.getNumFish();
    }

    public int getNumSharks() {
        return Shark.getNumSharks();
    }

    public Color getColor(int row, int col) {
        Actor a = this.theWorld.get(new Location(row, col));
        if (a == null) {
            return oceanColor;
        }
        return a.getColor();
    }

    public int getNumRows() {
        return this.theWorld.getNumRows();
    }

    public int getNumCols() {
        return this.theWorld.getNumCols();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        int r = 0;
        int rLimit = this.theWorld.getNumRows();
        while (r < rLimit) {
            int c = 0;
            int cLimit = this.theWorld.getNumCols();
            while (c < cLimit) {
                Actor a = this.theWorld.get(new Location(r, c));
                if (a == null) {
                    b.append('.');
                } else {
                    b.append(a.getChar());
                }
                ++c;
            }
            b.append('\n');
            ++r;
        }
        return b.toString();
    }

    public int getNumSpots() {
        return this.theWorld.getNumRows() * this.theWorld.getNumCols();
    }
}

