/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ParseTest {
    private StreamTokenizer myTokens;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private boolean OK;
    private int myArgCount;
    private StringBuffer myInput;

    public ParseTest(String filename) throws IOException {
        JarFile jarFile = new JarFile("apt.jar");
        JarEntry entry = jarFile.getJarEntry("input");
        InputStream input = jarFile.getInputStream(entry);
        this.myArgCount = 0;
        this.myInput = new StringBuffer();
        this.myTokens = new StreamTokenizer(new BufferedReader(new InputStreamReader(input)));
        this.myTokens.parseNumbers();
        this.myTokens.quoteChar(34);
        this.myTokens.whitespaceChars(44, 44);
        this.myTokens.ordinaryChar(91);
        this.myTokens.ordinaryChar(93);
    }

    public String[] parseVS(boolean input) throws IOException {
        String s;
        int val;
        ArrayList<String> list = new ArrayList<String>();
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        if ((val = this.myTokens.nextToken()) == -1) {
            throw new EOFException();
        }
        if (val != 91) {
            System.out.println("expected [ got " + this.myTokens.sval);
        }
        while ((val = this.myTokens.nextToken()) != 93) {
            s = this.myTokens.sval;
            if (val == -1) {
                throw new EOFException();
            }
            if (val == -2) {
                s = "" + (int)this.myTokens.nval;
            } else if (val != 34 && val != -3) {
                System.out.println("error parsing string " + val);
                break;
            }
            list.add(s);
        }
        if (list.size() == 1 && (s = (String)list.get(0)).length() == 0) {
            list = new ArrayList();
        }
        ++this.myArgCount;
        String[] out = list.toArray(new String[0]);
        if (input) {
            this.myInput.append(String.valueOf(this.print(out)) + "\n");
        }
        return out;
    }

    public int[] parseVI(boolean input) throws IOException {
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        int[] list = new int[200];
        int count = 0;
        int val = this.myTokens.nextToken();
        if (val == -1) {
            throw new EOFException();
        }
        if (val != 91) {
            System.out.println("expected [ got " + this.myTokens.sval);
        }
        while ((val = this.myTokens.nextToken()) != 93) {
            if (val != -2) {
                System.out.println("error parsing number " + val);
                break;
            }
            list[count++] = (int)this.myTokens.nval;
        }
        int[] ret = new int[count];
        System.arraycopy(list, 0, ret, 0, count);
        ++this.myArgCount;
        if (input) {
            this.myInput.append(String.valueOf(this.print(ret)) + "\n");
        }
        return ret;
    }

    public double[] parseVD(boolean input) throws IOException {
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        double[] list = new double[200];
        int count = 0;
        int val = this.myTokens.nextToken();
        if (val == -1) {
            throw new EOFException();
        }
        if (val != 91) {
            System.out.println("expected [ got " + this.myTokens.sval);
        }
        while ((val = this.myTokens.nextToken()) != 93) {
            if (val != -2) {
                System.out.println("error parsing number " + val);
                break;
            }
            list[count++] = this.myTokens.nval;
        }
        double[] ret = new double[count];
        System.arraycopy(list, 0, ret, 0, count);
        ++this.myArgCount;
        if (input) {
            this.myInput.append(String.valueOf(this.print(ret)) + "\n");
        }
        return ret;
    }

    public int getInt(boolean input) throws IOException {
        int val;
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        if ((val = this.myTokens.nextToken()) == -1) {
            throw new EOFException();
        }
        if (val != -2) {
            System.out.println("error reading int " + val);
            throw new IOException();
        }
        ++this.myArgCount;
        if (input) {
            this.myInput.append(String.valueOf(this.print((int)this.myTokens.nval)) + "\n");
        }
        return (int)this.myTokens.nval;
    }

    public double getDouble(boolean input) throws IOException {
        int val;
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        if ((val = this.myTokens.nextToken()) == -1) {
            throw new EOFException();
        }
        if (val != -2) {
            System.out.println("error reading double " + val);
            throw new IOException();
        }
        ++this.myArgCount;
        if (input) {
            this.myInput.append(String.valueOf(this.print(this.myTokens.nval)) + "\n");
        }
        return this.myTokens.nval;
    }

    public String getString(boolean input) throws IOException {
        int val;
        if (input) {
            this.myInput.append("ARG " + this.myArgCount + ":\n");
        }
        if ((val = this.myTokens.nextToken()) == -1) {
            throw new EOFException();
        }
        if (val != -3 && val != 34) {
            System.out.println("error reading string " + val);
            throw new IOException();
        }
        ++this.myArgCount;
        if (input) {
            this.myInput.append(String.valueOf(this.print(this.myTokens.sval)) + "\n");
        }
        return this.myTokens.sval;
    }

    public void parseAll() throws IOException {
        int val;
        while ((val = this.myTokens.nextToken()) != -1) {
            if (val == -2) {
                this.process(this.myTokens.nval);
                continue;
            }
            this.process(this.myTokens.sval);
        }
    }

    public double match(double d) throws IOException {
        this.OK = false;
        double good = this.getDouble(false);
        double dummy = this.getDouble(false);
        double min = Math.min(Math.abs(d), Math.abs(good));
        this.OK = min < 1.0E-5 ? true : Math.abs(d - good) / Math.min(Math.abs(d), Math.abs(good)) < 1.0E-5;
        return good;
    }

    public String match(String s) throws IOException {
        this.OK = false;
        String good = this.getString(false);
        String dummy = this.getString(false);
        this.OK = good.equals(s);
        return good;
    }

    public int match(int i) throws IOException {
        this.OK = false;
        int good = this.getInt(false);
        int dummy = this.getInt(false);
        this.OK = i == good;
        return good;
    }

    public int[] match(int[] list) throws IOException {
        int[] good = this.parseVI(false);
        int[] dummy = this.parseVI(false);
        this.OK = false;
        if (list == null) {
            return good;
        }
        boolean bl = this.OK = good.length == list.length;
        if (!this.OK) {
            return good;
        }
        int k = 0;
        while (k < good.length) {
            if (good[k] != list[k]) {
                this.OK = false;
            }
            ++k;
        }
        return good;
    }

    public String[] match(String[] list) throws IOException {
        String[] good = this.parseVS(false);
        String[] dummy = this.parseVS(false);
        this.OK = false;
        if (list == null) {
            return good;
        }
        boolean bl = this.OK = good.length == list.length;
        if (!this.OK) {
            return good;
        }
        int k = 0;
        while (k < good.length) {
            if (!good[k].equals(list[k])) {
                this.OK = false;
            }
            ++k;
        }
        return good;
    }

    public boolean ok() {
        return this.OK;
    }

    private void process(double value) {
    }

    public void process(String value) {
    }

    public String print(String s) {
        if (s.length() == 0) {
            s = "\"\"";
        }
        return String.valueOf(s) + " ";
    }

    public String print(int i) {
        return String.valueOf(i) + " ";
    }

    public String print(double d) {
        return String.valueOf(d) + " ";
    }

    public String print(String[] list) {
        String out = "";
        out = String.valueOf(out) + LEFT_BRACKET;
        int k = 0;
        while (k < list.length - 1) {
            out = String.valueOf(out) + "\"" + list[k] + "\", ";
            ++k;
        }
        out = String.valueOf(out) + "\"" + list[list.length - 1] + "\" ] ";
        return out;
    }

    public String print(double[] list) {
        String out = "";
        out = String.valueOf(out) + LEFT_BRACKET;
        int k = 0;
        while (k < list.length - 1) {
            out = String.valueOf(out) + list[k] + ", ";
            ++k;
        }
        out = String.valueOf(out) + list[list.length - 1] + " ] ";
        return out;
    }

    public String printArgs() {
        String out = this.myInput.toString();
        this.myArgCount = 0;
        this.myInput = new StringBuffer();
        return out;
    }

    public String print(int[] list) {
        String out = "";
        out = String.valueOf(out) + LEFT_BRACKET;
        int k = 0;
        while (k < list.length - 1) {
            out = String.valueOf(out) + list[k] + ", ";
            ++k;
        }
        out = String.valueOf(out) + list[list.length - 1] + " ] ";
        return out;
    }
}

