/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class TableMaker {
    private String myFileName;
    private FileWriter myWriter;
    private ArrayList myEntries;

    public TableMaker(String fileName) {
        this.myFileName = fileName;
        this.myEntries = new ArrayList();
    }

    public void addEntry(String input, String output, String correctOutput, boolean isOK) {
        this.myEntries.add(new Entry(input, output, correctOutput, isOK));
    }

    private void writeHeader() throws IOException {
        String header = "<html>\n<head>\n<meta content=\"text/html; charset=ISO-8859-1\"\nhttp-equiv=\"content-type\">\n<title>Algorithmic Program Tester</title></head>\n";
        this.myWriter.write(header);
    }

    private void writeTableInit() throws IOException {
        String init = "<body>\n<table style=\"text-align: left; width: 770; height: 10px\" border=\"1\"\ncellspacing=\"2\" cellpadding=\"2\">\n<tbody>";
        this.myWriter.write(init);
    }

    private void writeGoodRow(int count) throws IOException {
        String entry = "<tr>\n<td\nstyle=\"vertical-align: top; background-color: rgb(51, 204, 0);\"><span\nstyle=\"font-weight: bold;\">" + count + "</span><br>\n" + "</td>\n" + "<td\n" + "style=\"vertical-align: top; width: 5000px; background-color: rgb(255, 255, 255);\"><span\n" + "style=\"color: rgb(0, 0, 0);\">[OK]</span><br>\n" + "</td>\n" + "</tr>\n" + "<tr>\n" + "</tr>\n";
        this.myWriter.write(entry);
    }

    private void writeEnd() throws IOException {
        String end = "</tbody>\n</table>\n<br>\n<br>\n</body>\n</html>\n";
        this.myWriter.write(end);
    }

    private void writeTableHeader() throws IOException {
        String header = "<tr>\n<td style=\"vertical-align: top; background-color: rgb(0, 0, 0);\" width=\"16\"><br>\n</td>\n<td style=\"vertical-align: top; background-color: rgb(0, 0, 0);\" width=\"734\"><span\nstyle=\"color: rgb(255, 255, 255);\"><span style=\"font-weight: bold;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp\nAlgorithmic Program Testing Results</span></span><br></td>\n</tr>\n";
        this.myWriter.write(header);
    }

    private void writeBadRow(String input, String output, String correctOutput, int count) throws IOException {
        String badEntry = "<tr>\n<td \nstyle=\"vertical-align: top; background-color: rgb(255, 0, 0); width: 1%;\"><span\nstyle=\"font-weight: bold;\">" + count + "</span><br>\n" + "</td>\n" + "<td style=\"vertical-align: top; width: 50%;\">\n" + "<span style=\"color: rgb(204, 0, 0);\"></span>" + "<big style=\"font-weight: bold;color: rgb(204, 0, 0);\">Input: </big><big><small>" + input + "\n" + "<span style=\"color: rgb(204, 0, 0);\"></span>" + "<big style=\"font-weight: bold;color: rgb(204, 0, 0);\">Program Output:</big><big><small>" + output + "\n" + "<span style=\"color: rgb(204, 0, 0);\"></span>" + "<big style=\"font-weight: bold;color: rgb(204, 0, 0);\">Expected Output:</big><big><small>" + correctOutput + "</small><span" + "style=\"font-weight: bold;\"></span></big></small></big></small></big><br>" + "</td>\n" + "</tr>\n";
        this.myWriter.write(badEntry);
    }

    public void makeTable() throws IOException {
        this.myWriter = new FileWriter(new File(this.myFileName));
        this.writeHeader();
        this.writeTableInit();
        this.writeTableHeader();
        Entry current = null;
        int k = 0;
        while (k < this.myEntries.size()) {
            current = (Entry)this.myEntries.get(k);
            if (current.isOK) {
                this.writeGoodRow(k);
            } else {
                this.writeBadRow(current.input, current.output, current.correctOutput, k);
            }
            ++k;
        }
        this.writeEnd();
        this.myWriter.close();
    }

    public static final void main(String[] args) {
        TableMaker t = new TableMaker("output.html");
        try {
            t.addEntry("", "", "", true);
            t.addEntry("Display HTML in a widget. In Eclipse 2.0 and 2.1, the only supported option for rendering HTML in the workbench is to use OLE to link to IE. This supportis Windows only; there is no such option in other operating environments. Evenon Windows, this only works for IE and not other browsers. There are alreadyseveral Eclipse components that could benefit from HTML display functionalityin a widget: welcome pages; update manager update site overview; hovers thatshow Javadoc. The Platform should provide a portable way to display HTML in awidget and support it in all operating environments. [Platform UI] [Themes:", "Display HTML in a widget. In Eclipse 2.0 and 2.1, the only supported option for rendering HTML in the workbench is to use OLE to link to IE. This supportis Windows only; there is no such option in other operating environments. Evenon Windows, this only works for IE and not other browsers. There are alreadyseveral Eclipse components that could benefit from HTML display functionalityin a widget: welcome pages; update manager update site overview; hovers thatshow Javadoc. The Platform should provide a portable way to display HTML in awidget and support it in all operating environments. [Platform UI] [Themes:", "Display HTML in a widget. In Eclipse 2.0 and 2.1, the only supported option for rendering HTML in the workbench is to use OLE to link to IE. This supportis Windows only; there is no such option in other operating environments. Evenon Windows, this only works for IE and not other browsers. There are alreadyseveral Eclipse components that could benefit from HTML display functionalityin a widget: welcome pages; update manager update site overview; hovers thatshow Javadoc. The Platform should provide a portable way to display HTML in awidget and support it in all operating environments. [Platform UI] [Themes:", false);
            t.makeTable();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class Entry {
        String input;
        String output;
        String correctOutput;
        boolean isOK;

        public Entry(String input, String output, String correctOutput, boolean isOK) {
            this.input = input;
            this.output = output;
            this.isOK = isOK;
            this.correctOutput = correctOutput;
        }
    }
}

