package SCRIPTS.Code;
import java.io.*;
import java.util.*;

public class MetaTester {
	private static String[] tags = { "return:", "class:", "method:", "arg:" };

	private static String[] testTags = { "RETURN", "CLASS", "METHOD",
			"ARGPARSE", "ARGCALL", "PRINTARGS" };

	private static String RETURN = tags[0];

	private static String META_RETURN = testTags[0];

	private static String CLASS = tags[1];

	private static String META_CLASS = testTags[1];

	private static String METHOD = tags[2];

	private static String META_METHOD = testTags[2];

	private static String META_ARGPARSE = testTags[3];

	private static String META_ARGCALL = testTags[4];

	private static String META_PRINTARGS = testTags[5];

	private static final String ARG = "arg:";

	private static final String SPECFILE = "prob.spec";

	private static final String TESTFILE = "TesterSkel";

	private static final String OUTFILE = "Tester.java";

	private static int QUOTE = '\"';

	private static Map ourParseMap = new HashMap();
	static {
		ourParseMap.put("int", " p.getInt(true);");
		ourParseMap.put("double", " p.getDouble(true);");
		ourParseMap.put("String", " p.getString(true);");
		ourParseMap.put("int[]", " p.parseVI(true);");
		ourParseMap.put("double[]", " p.parseVD(true);");
		ourParseMap.put("String[]", " p.parseVS(true);");
	};

	private Map myMap;

	private ArrayList myArgs;

	public MetaTester() {
		myMap = new HashMap();
		myArgs = new ArrayList();
		try {
			readspec();
		} catch (Exception e) {
			System.out.println("trouble parsing " + e);
		}
		loadMap();
	}

	private void loadMap() {
		myMap.put(META_RETURN, myMap.get(RETURN));
		myMap.put(META_CLASS, myMap.get(CLASS));
		myMap.put(META_METHOD, myMap.get(METHOD));

		String argparse = "";
		String argcall = "";
		String printargs = "";
		char var = 'a';
		for (int k = 0; k < myArgs.size(); k++) {
			String type = (String) myArgs.get(k);
			argparse = argparse + "final " + type + " " + var + ";\n" + var
					+ " = " + (String) ourParseMap.get(type) + "\n";
			argcall = argcall + var + ",";

			printargs = printargs + "p.print(printer," + var + ");\n";

			var++;
		}
		myMap.put(META_ARGPARSE, argparse);

		// chop off last comma to complete call

		argcall = argcall.substring(0, argcall.length() - 1);
		myMap.put(META_ARGCALL, argcall);
		myMap.put(META_PRINTARGS, printargs);
	}

	private void readspec() throws Exception {

		BufferedReader r = new BufferedReader(new FileReader(SPECFILE));


		String line;

		while ((line = r.readLine()) != null) {
			for (int k = 0; k < tags.length; k++) {
				int pos = line.indexOf(tags[k]);
				if (pos >= 0) {
					String stag = line.substring(0, tags[k].length());
					String val = line
							.substring(tags[k].length(), line.length());
					val = val.trim();
					if (ARG.equals(stag)) {
						myArgs.add(val);
					} else {
						myMap.put(tags[k], val);
					}
					break;
				}
			}
			// System.out.println("read "+line);
		}
		// printSpec();	
	}

	private void printSpec() {

		// don't parse arg:, hence length-1 below

		for (int k = 0; k < tags.length - 1; k++) {
			String val = (String) myMap.get(tags[k]);
			System.out.print(tags[k] + " ");
			if (val == null) {
				System.out.println("not parsed");
			} else {
				System.out.println(val);
			}
		}
		System.out.println("arguments:");
		for (int k = 0; k < myArgs.size(); k++) {
			System.out.print(" " + myArgs.get(k));
		}
		System.out.println();
	}

	public void writeFile() throws Exception {
		PrintWriter printer = new PrintWriter(new BufferedWriter(
				new FileWriter(OUTFILE)));
		BufferedReader r = new BufferedReader(new FileReader(TESTFILE));
		StreamTokenizer izer = new StreamTokenizer(r);
		izer.eolIsSignificant(true);
		izer.parseNumbers();
		izer.quoteChar(QUOTE);

		while (true) {
			int token;
			token = izer.nextToken();
			if (token == StreamTokenizer.TT_EOF) {
				break;
			} else if (token == StreamTokenizer.TT_EOL) {
				printer.println();
			} else if (token == StreamTokenizer.TT_WORD) {
				writeOnce(printer, izer.sval);
			} else if (token == StreamTokenizer.TT_NUMBER) {
				printer.print((int) izer.nval);
				//		writeOnce(printer,""+ (int)izer.nval);
			} else {
				if (izer.ttype == QUOTE) {
					writeOnce(printer, ((char) QUOTE) + izer.sval
							+ ((char) QUOTE));
				} else {
					printer.print((char) izer.ttype);
					//		    writeOnce(printer,""+(char)izer.ttype);   
				}
			}
		}
		printer.close();

	}

	private void writeOnce(PrintWriter printer, String s) {
		String value = (String) myMap.get(s);
		if (value != null) {
			printer.print(" " + value);
		} else {
			printer.print(" " + s);
		}
	}


	public static void main(String[] args) {
		MetaTester mt = new MetaTester();
		try {
			mt.writeFile();
		} catch (Exception e) {
			System.out.println("trouble writing Tester.java");
			e.printStackTrace();
		}
	}
}
