
package SCRIPTS.Code;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.io.*;

class EOFException extends RuntimeException {
	public EOFException() {

	}
}

public class ParseTest {
	private StreamTokenizer myTokens;
	private final static String LEFT_BRACKET = "[";
	private final static String RIGHT_BRACKET = "]";
	private boolean OK;
	private int myArgCount;
	private StringBuffer myInput;
	
	public ParseTest(String filename) throws IOException {
		JarFile jarFile = new JarFile("apt.jar");
	       JarEntry entry = jarFile.getJarEntry("input");
	    InputStream input =  jarFile.getInputStream(entry);
		myArgCount = 0;
	    myInput = new StringBuffer();
	    
		myTokens = new StreamTokenizer(new BufferedReader(new InputStreamReader(input)));
		myTokens.parseNumbers();
		myTokens.quoteChar('"');
		myTokens.whitespaceChars(',', ',');
		myTokens.ordinaryChar('[');
		myTokens.ordinaryChar(']');
	}

	public String[] parseVS(boolean input) throws IOException {
		ArrayList list = new ArrayList();
		if(input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
		int val;
		val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != '[') {
			System.out.println("expected [ got " + myTokens.sval);
		}
		//	System.out.print("..parsing strings ");
		while (true) {
			val = myTokens.nextToken();
			if (val == ']') {
				break;
			}
			String s = myTokens.sval;
			if (val == StreamTokenizer.TT_EOF) {
				throw new EOFException();
			} else if (val == StreamTokenizer.TT_NUMBER) {
				s = "" + (int) myTokens.nval;
			} else if (val == '"') {
				// ok
			} else if (val != StreamTokenizer.TT_WORD) {
				System.out.println("error parsing string " + val);
				break;
			}
			//	    System.out.print(s + " ");
			list.add(s);
		}
		//	System.out.println(" :done parse");
		if (list.size() == 1) {
			String s = (String) list.get(0);
			if (s.length() == 0) {
				list = new ArrayList();
			}
		}
		myArgCount++;
		String[] out = (String[]) list.toArray(new String[0]);
        if(input){
        	myInput.append(print(out)+"\n");
        }
		return out;
	}

	public int[] parseVI(boolean input) throws IOException {
		if(input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
		int[] list = new int[200];
		int count = 0;
		int val;  
		val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != '[') {
			System.out.println("expected [ got " + myTokens.sval);
		}
		while (true) {
			val = myTokens.nextToken();
			if (val == ']') {
				break;
			}
			if (val != StreamTokenizer.TT_NUMBER) {
				System.out.println("error parsing number " + val);
				break;
			}
			list[count++] = (int) myTokens.nval;
		
		}
		int[] ret = new int[count];
		System.arraycopy(list, 0, ret, 0, count);
		myArgCount++;
		if(input){
			myInput.append(print(ret)+"\n");
		}
		return ret;
	}

	public double[] parseVD(boolean input) throws IOException {
		
		if(input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
		
		double[] list = new double[200];
		int count = 0;
		int val;
		val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != '[') {
			System.out.println("expected [ got " + myTokens.sval);
		}
		while (true) {
			val = myTokens.nextToken();
			if (val == ']') {
				break;
			}
			if (val != StreamTokenizer.TT_NUMBER) {
				System.out.println("error parsing number " + val);
				break;
			}
			list[count++] = myTokens.nval;
;
		}
		double[] ret = new double[count];
		System.arraycopy(list, 0, ret, 0, count);
		myArgCount++;
		
		if(input){
			myInput.append(print(ret) + "\n");
		}
		return ret;
	}

	public int getInt(boolean input) throws IOException {
		if (input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
	    int val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != StreamTokenizer.TT_NUMBER) {
			System.out.println("error reading int " + val);
			throw new IOException();
		}
		myArgCount++;
		if(input){
			myInput.append(print((int)myTokens.nval) + "\n");
		}
		return (int) myTokens.nval;
	}

	public double getDouble(boolean input) throws IOException {
		if(input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
		
		int val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != StreamTokenizer.TT_NUMBER) {
			System.out.println("error reading double " + val);
			throw new IOException();
		}
		myArgCount++;
		if(input){
			myInput.append(print(myTokens.nval) + "\n");
		}
		return myTokens.nval;
	}

	public String getString(boolean input) throws IOException {
		if(input){
			myInput.append("ARG " + myArgCount + ":\n");
		}
		int val = myTokens.nextToken();
		if (val == StreamTokenizer.TT_EOF) {
			throw new EOFException();
		}
		if (val != StreamTokenizer.TT_WORD && val != '"') {
			System.out.println("error reading string " + val);
			throw new IOException();
		}
		//	System.out.println("parsed  "+myTokens.sval);
		myArgCount++;
		if(input){
			myInput.append(print(myTokens.sval) + "\n");
		}
		return myTokens.sval;
	}

	public void parseAll() throws IOException {
		int val;
		while ((val = myTokens.nextToken()) != StreamTokenizer.TT_EOF) {
			if (val == StreamTokenizer.TT_NUMBER) {
				process(myTokens.nval);
			} else {
				process(myTokens.sval);
			}
		}
	}

	public double match(double d) throws IOException {
		OK = false;
		double good = getDouble(false);
		double dummy = getDouble(false);
		double min = Math.min(Math.abs(d), Math.abs(good));
		if (min < 10e-6) {
			OK = true;
		} else {
			OK = Math.abs(d - good) / Math.min(Math.abs(d), Math.abs(good)) < 10e-6;
		}
		return good;

	}

	public String match(String s) throws IOException {
		OK = false;
		String good = getString(false);
		String dummy = getString(false);
		OK = good.equals(s);
		return good;
	}

	public int match(int i) throws IOException {
		OK = false;
		int good = getInt(false);
		int dummy = getInt(false);
		OK = i == good;
		return good;
	}

	public int[] match(int[] list) throws IOException {
		int[] good = parseVI(false);
		int[] dummy = parseVI(false);
		OK = false;
		if (list == null)
			return good;
		OK = good.length == list.length;
		if (!OK)
			return good;

		for (int k = 0; k < good.length; k++) {
			if (good[k] != list[k])
				OK = false;
		}
		return good;
	}

	public String[] match(String[] list) throws IOException {
		String[] good = parseVS(false);
		String[] dummy = parseVS(false);
		OK = false;

		if (list == null)
			return good;

		OK = good.length == list.length;
		if (!OK)
			return good;

		for (int k = 0; k < good.length; k++) {
			if (!good[k].equals(list[k]))
				OK = false;
		}
		return good;
	}

	public boolean ok() {
		return OK;
	}

	private void process(double value) {

	}

	public void process(String value) {

	}

	public String print(String s) {
		if (s.length() == 0) {
			s = "\"\"";
		}
		
		return (s+" ");
	}

	public String print( int i) {
		return (i + " ");
	}

	public String print( double d) {
		return (d + " ");
	}

	public String print (String[] list) {
		String out="";
		
		out=out+"[";
		
		for (int k = 0; k < list.length - 1; k++) {
			out=out+"\"" + list[k] + "\", ";
		}
		out=out+"\"" + list[list.length - 1] + "\" ] ";
		return out;
	}

	public String print(double[] list) {
		String out="";
		
		out = out +"[";
		for (int k = 0; k < list.length - 1; k++) {
			out = out+list[k] + ", ";
		}
		out=out+list[list.length - 1] + " ] ";
		
		return out;
	}

	public String printArgs(){
		String out= myInput.toString();
		myArgCount = 0;
		myInput = new StringBuffer();
		return  out;
	}
	
	public String print(int[] list) {
		String out="";
		
		out=out+"[";
		
		for (int k = 0; k < list.length - 1; k++) {
			out=out+list[k] + ", ";
		}
		out=out+list[list.length - 1] + " ] ";
		
		return out;
	}
}
