#!/bin/sh
# This script was generated using Makeself 2.1.3
CRCsum="1422902055"
MD5="00000000000000000000000000000000"
TMPROOT=${TMPDIR:=/tmp}

label="APT Builder"
script="./run.sh"
scriptargs=""
targetdir="engine"
filesizes="10706"
keep=y

print_cmd_arg=""
if type printf > /dev/null; then
    print_cmd="printf"
elif test -x /usr/ucb/echo; then
    print_cmd="/usr/ucb/echo"
else
    print_cmd="echo"
fi

MS_Printf()
{
    $print_cmd $print_cmd_arg "$1"
}

MS_Progress()
{
    while read a; do
	MS_Printf .
    done
}

MS_dd()
{
    blocks=`expr $3 / 1024`
    bytes=`expr $3 % 1024`
    dd if="$1" ibs=$2 skip=1 obs=1024 conv=sync 2> /dev/null | \
    { test $blocks -gt 0 && dd ibs=1024 obs=1024 count=$blocks ; \
      test $bytes  -gt 0 && dd ibs=1 obs=1024 count=$bytes ; } 2> /dev/null
}

MS_Help()
{
    cat << EOH >&2
Makeself version 2.1.3
 1) Getting help or info about $0 :
  $0 --help   Print this message
  $0 --info   Print embedded info : title, default target directory, embedded script ...
  $0 --lsm    Print embedded lsm entry (or no LSM)
  $0 --list   Print the list of files in the archive
  $0 --check  Checks integrity of the archive
 
 2) Running $0 :
  $0 [options] [--] [additional arguments to embedded script]
  with following options (in that order)
  --confirm             Ask before running embedded script
  --noexec              Do not run embedded script
  --keep                Do not erase target directory after running
			the embedded script
  --nox11               Do not spawn an xterm
  --nochown             Do not give the extracted files to the current user
  --target NewDirectory Extract in NewDirectory
  --tar arg1 [arg2 ...] Access the contents of the archive through the tar command
  --                    Following arguments will be passed to the embedded script
EOH
}

MS_Check()
{
    OLD_PATH=$PATH
    PATH=${GUESS_MD5_PATH:-"$OLD_PATH:/bin:/usr/bin:/sbin:/usr/local/ssl/bin:/usr/local/bin:/opt/openssl/bin"}
    MD5_PATH=`exec 2>&-; which md5sum || type md5sum`
    MD5_PATH=${MD5_PATH:-`exec 2>&-; which md5 || type md5`}
    PATH=$OLD_PATH
    MS_Printf "Verifying archive integrity..."
    offset=`head -n 361 "$1" | wc -c | tr -d " "`
    verb=$2
    i=1
    for s in $filesizes
    do
	crc=`echo $CRCsum | cut -d" " -f$i`
	if test -x "$MD5_PATH"; then
	    md5=`echo $MD5 | cut -d" " -f$i`
	    if test $md5 = "00000000000000000000000000000000"; then
		test x$verb = xy && echo " $1 does not contain an embedded MD5 checksum." >&2
	    else
		md5sum=`MS_dd "$1" $offset $s | "$MD5_PATH" | cut -b-32`;
		if test "$md5sum" != "$md5"; then
		    echo "Error in MD5 checksums: $md5sum is different from $md5" >&2
		    exit 2
		else
		    test x$verb = xy && MS_Printf " MD5 checksums are OK." >&2
		fi
		crc="0000000000"; verb=n
	    fi
	fi
	if test $crc = "0000000000"; then
	    test x$verb = xy && echo " $1 does not contain a CRC checksum." >&2
	else
	    sum1=`MS_dd "$1" $offset $s | cksum | awk '{print $1}'`
	    if test "$sum1" = "$crc"; then
		test x$verb = xy && MS_Printf " CRC checksums are OK." >&2
	    else
		echo "Error in checksums: $sum1 is different from $crc"
		exit 2;
	    fi
	fi
	i=`expr $i + 1`
	offset=`expr $offset + $s`
    done
    echo " All good."
}

UnTAR()
{
    tar $1vf - 2>&1 || { echo Extraction failed. > /dev/tty; kill -15 $$; }
}

finish=true
xterm_loop=
nox11=n
copy=none
ownership=y
verbose=n

initargs="$@"

while true
do
    case "$1" in
    -h | --help)
	MS_Help
	exit 0
	;;
    --info)
	echo Identification: "$label"
	echo Target directory: "$targetdir"
	echo Uncompressed size: 64 KB
	echo Compression: gzip
	echo Date of packaging: Thu May 26 14:08:38 EDT 2005
	echo Built with Makeself version 2.1.3 on solaris
	echo Build command was: "./makeself.sh /home/ugrad_06/pkn1/apt/apt/engine apt-make.sh APT Builder ./run.sh"
	if test x$script != x; then
	    echo Script run after extraction:
	    echo "    " $script $scriptargs
	fi
	if test x"" = xcopy; then
		echo "Archive will copy itself to a temporary location"
	fi
	if test x"y" = xy; then
	    echo "directory $targetdir is permanent"
	else
	    echo "$targetdir will be removed after extraction"
	fi
	exit 0
	;;
    --dumpconf)
	echo LABEL=\"$label\"
	echo SCRIPT=\"$script\"
	echo SCRIPTARGS=\"$scriptargs\"
	echo archdirname=\"engine\"
	echo KEEP=y
	echo COMPRESS=gzip
	echo filesizes=\"$filesizes\"
	echo CRCsum=\"$CRCsum\"
	echo MD5sum=\"$MD5\"
	echo OLDUSIZE=64
	echo OLDSKIP=362
	exit 0
	;;
    --lsm)
cat << EOLSM
No LSM.
EOLSM
	exit 0
	;;
    --list)
	echo Target directory: $targetdir
	offset=`head -n 361 "$0" | wc -c | tr -d " "`
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "gzip -cd" | UnTAR t
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
	--tar)
	offset=`head -n 361 "$0" | wc -c | tr -d " "`
	arg1="$2"
	shift 2
	for s in $filesizes
	do
	    MS_dd "$0" $offset $s | eval "gzip -cd" | tar "$arg1" - $*
	    offset=`expr $offset + $s`
	done
	exit 0
	;;
    --check)
	MS_Check "$0" y
	exit 0
	;;
    --confirm)
	verbose=y
	shift
	;;
	--noexec)
	script=""
	shift
	;;
    --keep)
	keep=y
	shift
	;;
    --target)
	keep=y
	targetdir=${2:-.}
	shift 2
	;;
    --nox11)
	nox11=y
	shift
	;;
    --nochown)
	ownership=n
	shift
	;;
    --xwin)
	finish="echo Press Return to close this window...; read junk"
	xterm_loop=1
	shift
	;;
    --phase2)
	copy=phase2
	shift
	;;
    --)
	shift
	break ;;
    -*)
	echo Unrecognized flag : "$1" >&2
	MS_Help
	exit 1
	;;
    *)
	break ;;
    esac
done

case "$copy" in
copy)
    SCRIPT_COPY="$TMPROOT/makeself$$"
    echo "Copying to a temporary location..." >&2
    cp "$0" "$SCRIPT_COPY"
    chmod +x "$SCRIPT_COPY"
    cd "$TMPROOT"
    exec "$SCRIPT_COPY" --phase2
    ;;
phase2)
    finish="$finish ; rm -f $0"
    ;;
esac

if test "$nox11" = "n"; then
    if tty -s; then                 # Do we have a terminal?
	:
    else
        if test x"$DISPLAY" != x -a x"$xterm_loop" = x; then  # No, but do we have X?
            if xset q > /dev/null 2>&1; then # Check for valid DISPLAY variable
                GUESS_XTERMS="xterm rxvt dtterm eterm Eterm kvt konsole aterm"
                for a in $GUESS_XTERMS; do
                    if type $a >/dev/null 2>&1; then
                        XTERM=$a
                        break
                    fi
                done
                chmod a+x $0 || echo Please add execution rights on $0
                if test `echo "$0" | cut -c1` = "/"; then # Spawn a terminal!
                    exec $XTERM -title "$label" -e "$0" --xwin "$initargs"
                else
                    exec $XTERM -title "$label" -e "./$0" --xwin "$initargs"
                fi
            fi
        fi
    fi
fi

if test "$targetdir" = "."; then
    tmpdir="."
else
    if test "$keep" = y; then
	echo "Creating directory $targetdir" >&2
	tmpdir="$targetdir"
    else
	tmpdir="$TMPROOT/selfgz$$"
    fi
    mkdir -p $tmpdir || {
	echo 'Cannot create target directory' $tmpdir >&2
	echo 'You should try option --target OtherDirectory' >&2
	eval $finish
	exit 1
    }
fi

location="`pwd`"
if test x$SETUP_NOCHECK != x1; then
    MS_Check "$0"
fi
offset=`head -n 361 "$0" | wc -c | tr -d " "`

if test x"$verbose" = xy; then
	MS_Printf "About to extract 64 KB in $tmpdir ... Proceed ? [Y/n] "
	read yn
	if test x"$yn" = xn; then
		eval $finish; exit 1
	fi
fi

MS_Printf "Uncompressing $label"
res=3
if test "$keep" = n; then
    trap 'echo Signal caught, cleaning up >&2; cd $TMPROOT; /bin/rm -rf $tmpdir; eval $finish; exit 15' 1 2 3 15
fi

for s in $filesizes
do
    if MS_dd "$0" $offset $s | eval "gzip -cd" | ( cd "$tmpdir"; UnTAR x ) | MS_Progress; then
		if test x"$ownership" = xy; then
			(PATH=/usr/xpg4/bin:$PATH; cd "$tmpdir"; chown -R `id -u` .;  chgrp -R `id -g` .)
		fi
    else
		echo
		echo "Unable to decompress $0" >&2
		eval $finish; exit 1
    fi
    offset=`expr $offset + $s`
done
echo

cd "$tmpdir"
res=0
if test x"$script" != x; then
    if test x"$verbose" = xy; then
		MS_Printf "OK to execute: $script $scriptargs $* ? [Y/n] "
		read yn
		if test x"$yn" = x -o x"$yn" = xy -o x"$yn" = xY; then
			eval $script $scriptargs $*; res=$?;
		fi
    else
		eval $script $scriptargs $*; res=$?
    fi
    if test $res -ne 0; then
		test x"$verbose" = xy && echo "The program '$script' returned an error code ($res)" >&2
    fi
fi
if test "$keep" = n; then
    cd $TMPROOT
    /bin/rm -rf $tmpdir
fi
eval $finish; exit $res
 BZxՕL2!$<B4WHB IIqHd 3$*>>  MkmU_kwխڭݭ֭vwm*dh}ɗs=L]ӲmX0F)-+-@ii,-_jTb~EYiYUTTTç/GdP٘pXԻ+|~|Ol.Eoo:6b@ʸM!sq0-UZ`	w8N`(׳1io(v$(m
F&xS	Xj	E˂4a?
9B
E5<Ń0+pprY3L h4D?4b~i OyeeeG/sBsVmߴqs=mwXm"P'-V
\zVs|
u ou@zF&+j1Uݼ|UusKV]SҎusUs}c+Ƃj!J:[tV91$YV%q9@S8ZjLl	t;1,kde=G'g5r@sKxC͈X{.;GO鯎rR@#7	_wj,"u@/fkK8u;ؘ82'Nw.`ĩMNTzb.uԖtvAkgtV+nVזt յ3
d5If(*I\YvgYhN?Zq-8LʜS0sGCX/0kmT#dS8;R3.px?)hsb_{$PxȜL=I Uh[r0Mk= Sj@牖kMjI}Zv24*\.p'$$D1.2p
OCJ",!o*\=WܑFߦM⽮#XD@6ʡ'n ΢Ѭ5A7p=nTPhlHnNeqasLar3{;;;rYM땎=
j{LM Sf&/Uwثӑ@Gᘍ
prg|CJU֏mх|6}"IN=](eS0!M\=sc
yE5c	
\N<E,g8gYx[HT>GY2J  vEKHw 2U\}קe?U>6_UZh>H_#ф^&,zg:L	>1&D.TآUComuӚ93\	XC1#k#&c_Wknaގ,"O\MU*g7ibYdf=شOP8J)
x̪XZe'#9@$KeEblY$ǻ1B)5\jK9D)	ӹBKqԱ"@>7yG"3QQz54	;/t8kʗ8
l
U@mgL!.&
u"O{`US*.a֢[=5l%PTs)ȘxXYMz*fjlFxZ HxrwDR%pE	Ou`YT[awQM0&
bRTGV+۽g*Sj=[nʩz=Ug75;os'^_5b.LԏX^-,P.oUcrUf[$]N%u\sMiOe{ZJ;)㈇GWBwUF#NS8
V(ݬ'Q쳹=->{N.mesZ<;'c26_[|N"B-9r[Av Kfβm)v\ζ,3YdŲeSvABok8۽ǰцpont77ݡF;2܈
3,r>ɣ
_F,aYMSd)&E8(~22Z&2qY5z1/QJ`iM0[R<bkp!Y.=kp} nmqn{ȦS3J!I*|>urt!X[̿%\sq܇Y$Ė!*K~E,Y,?,N{gdSg5G
ԛ^
v[c 	ti#AqUt8ȽL~W='O'k:-Sd.hL3d|ߛ9v;+;*!tX9܂{G`4xRwT2Rti(XZ4zgcu8z</ua> zFM糮gJjr)"KG@Լ Vf:oGJ;(58f/~+؉aVjHD!O}xkxնt A9<xr$_X="PQٍltLq vT>45<a.{#lQh.L
--	q[Ч٬Vp)5;o$sZ.0XsZV,OҦ9b#]Z{+OpeM݌yL$JbL{Ry{ǽ6'$\D$\Σ%<aT4\1IEtS...^C<
WNCb>IvY\̠x
#41SrpvQy~H9}C>nP3$oRLulR<jrc=U^Y-؇rٮ}p͎0xv#AU<U]3禸*V>6ųz磪LiI?BjL3+-fkpzUF
<InLEI/qNZ.*n{6R	_AwSy!Ӂ߇8-i܆gq?Z&+-qLŃjZJV"Q|:MN\irN;.$9LTKQ2Ivs!WS Շx>LJxkYjQ˚EjL@mS,qDL!dr/_?I
$V$<q(GG9]_c{9$]SjpNU/Tղ3Ռ/>_,itt3s0Fӯ߭ѱ߳nY3kVֵQmN\|E\^&2V/S,	IB,Y=!:ZP/%U><"<7DU&.1x͓h"oG9Y^XG(0-q}>3㌺P,?fl3^dV0)LI"50(e޹낽YIɥL bd¸帙3F/:oPq\@MJCNbx!Z^S\|--0.NsRwZ2uȀvyR.g
M<+D{B4%JxÑ`MU!{(	MԧGBM"iNIS8TJ8LIiݬYs\zSw  6Ы\NtAl[>K!
F(yE=L[eiRV>-eu.{ET^@GA[Ag8FF]ǥ/--tEjZJq%;pUjؓku$#䗙]0s`:=~nAb/^#Dh<NjmV]LhZx=" -:`/o?W8%m4F|_XWIo:7s嵌^(0^=?!O>MMq}0r(\?D*j-*k-*k5Q<+x+xi&̈́IFvG!qk/qb|QpD$&$\8"FU}_U_:g7b!p]ˊ?oҬM9JꉄRL?rBk2Ajr~L/Ȼ<lǺ1<;._#IGQkFpa2-gHg H8Ѯ6vAG(3X
1KX/T
B2
ʥ{QlԲ% d.2gmAc!j:ǥdf$~e񉄠#1ȌȞLGJg520m#=A0[y%oT,&GGXi|B+Dg8f5zJ(an|(?
V+}C8UiA,部>GP2)8SW<ٞ8u-պ3ќ吰\nb
kS1$$֖#8ky܈lHhIFeЊhL@'	s:؈ɇѦ@Ɏ)Elj6p6	B68v6G/ך{-؇Cʉ?ݶv=sf#<1:eTG dF3&R@$UgEa~{1#܍\.߄B83ǭkHIf'B-]`O]#[.qs)rIgp_=2gQ|븿=̉i"Nҙ1Pl,ds(ҹh<פlrB\[-Xa)ϜN˨k(X}PU^hThRXU/Lk':8UIiIƵ}xX}~ tC#EcY{EM&'\
ܭPjR9Ϫ12ҙd݋ĬCMdOJMpU9<i[xlXGj㨮Illɲ-"jwe}%ؖ@,X펤ūʲ %Є$W$|MS,l %)iӞ96Mz6%䏦i}͇v%Yv0Z{gg{s߽{ߝ;<M~d_иV>0V3V+VUWc
@d"lD\:D_<~zRЀERKe藰DIN믙KM`BQ -_窵wXkϤ*z}oMi1 8 JJJɈ{{hI(SPڧ(}s>_Bw0ZWi;J{Qi(e=TRi
VYxj6
mz
uA!vMpx[z?y
Wk(1A8}ȩ'GhrTr
)~ᙱ	c3A?9޿َC	 3	d2A@y s
ȜA氃aBd4 2ዬߟ=>p8>w=ː໐/!+篩~ 7p?a\ σ>:d|~Jk
¿p'04%4>JK\E_u#75?!.	.?p֨9+FP=~QKtsPkAD+ZnXW^X~s˴(XvG຺ATzYE)&VڣJx7ӯ__Q ^@c:7W3[[qSt/g@ZsP_H_;vW0ߢ0Z
@X&%R3|5W52laU	Xey]/c/oێ]jc迱-]DCkmE8Mi`oIop`C?F
FN%}ONyUv+7hE$!*']bTO=H;M*paYXH+RZ1ʩXD
XL۱Ǹc==2*uCBH*bĶƲ\(e]8wYWA&9/kVAʸ⮆k n
Ľ⾇[9AG!R.WFL"
:pZ`Ge9I?'7KNW8`;W3Թ$#0#2I1]EF$EH(VٵC2+B6@p7$_鞺tOL~	+Z<dz19dK$Ʋv@

cbٿVQInӚy*jԄ8)Yeԭ8))$n^-l*cۻ-QF1vP~.6$\6#WSb)KZhb	ShQSe\\ ϼH53	@@=t9~5sɠXQ	t:!d܀ظ䱊պ2ͱb9\	 	 ܭ3^9ǝfVN43iMZo;Z#9Y8fe28e>.Id,<]ș"n8|X*7d1OQas)ڬJXB8}WiN

l+_G .]IA)]
H2*wi-ӿ ҥ,%|bg̈́%t#ɶ"8IUq`qZ^pW^c
	~tIUBq[qL>DVQ:tZ DxT?W._$)r^ըnpR>19n|ݼy.fFcK"Mˆԫo-.|9˒gL؛8|LiJU>ZW_q<z%ex\'4c@jDZ̽庾HySReA
冓!a31+3Sv<k"9wfk/o~7˥$9r\29hDLXȶբA\F_{SH+h3Up@fHDVIEu|
ʵ[1D674Ldb0"@U&⹡ysc2C1}/H!kL&9l7D}̽8!$!x5SgҠ[r&incѤqJh`IcVʴ`y}X45nƺVGMTQ-ZAmїpse>Ǭhk.:3k:kpdR4	H,|/1rlh5̈́HSs3 25^S4oti|*66{\rejŹvhNz6 ;ܽ4UjȖ(:[ꚾEWٖ$ޒ\  	;EvyzFYLT6:l}3y`Τ1#\6t޵ٗ-Q+߈c9(#]KEdWa<Cku^V®nOl3-<1&7h2	
qݹѶ8{n;YB/j9F)اNw{-#Rӱc7(N-L[UxQ*zicԪAwߙ?ASp9½OW{}|g+(1WP!WЭt[&`;aУ\jPila*7CͬKZUX7NГt]OEml:W(ѕd"5ESQDSq"0
J%Dv$2l.BŀM.ɦǴ~3,ƧݝLoWgD&52,)+f&*:X)LDt4Sh 	ESlwuJyIE?f&LqQ&9y,kD:1k8m/p<k$rb c
+,ꁑT9ʍy ofxA3*Fh3a[X``E˻5*1ĭ[IFsoXJg8$GہI5" 
$3B鰯&,jޱ
2?f:u4,2Fn[SY~g;E2՘_=U2x^WE$hg~q|jRwԹ+ʓ$CId]Vc]Ւz\¡]c^.J^.J>8\NM."R/#zQЍn_QīlMҭGڲ>ϕBsP[$E|g}>jbH2LGgтq6ILՕ˛>\~{onu:6"G`u=&ri#]F ^ތѶvUN~GY;PEf͜R	ж ڀmp>3q
/9	Jǵ0c)ZhIC1	Ռś&MwFQlSưy3>Eagbl\Q,j}FP[]4fV`\KCiL3D(EY*3h43rI}>24no1*'I#~%a>ot+k&_ z> -
L / ʾtwQ'G~DQzeFCc6@t;
b,Fw=niXja8j0$"3}_҉CDwt[w'虣TF0k2h5j#ry{Pz(,x #a~0ZR!a\~h=`z	=ym:Iߖcy	):<sg]76Nlؼ}57ͯn|2B@3"žžH2rJP?+/պݸcG7߲f4z:Ըjd֜Ӷqbda=Tn,<#A7=h%;BȂ:}be(1e
OM 
˹lڝ.rg
~G_WW ~>/B%y׵^1uc 8~V>yvxj
h\-+W`.a 3H($䱽fԛ ԛ0U]7ji[Ig!eJȲ\?dc
OW(
3|o8СPKJ505`-_+{n-(+ 6nc?Z=VCk0HmVJ/_
_jamtktok&lAf$3㚂dU
^(7yM2R!mĝE:"_(%i"VѾ\&
L/L'rmq"<v}hf:er[-{?!H3	{1j7Wy>F!_ACY=_[с0膅"
s]XPtD~.ԕ][obi!C$:= X*FS8BР?zq(Bebu PWw?/k悏-64|aʱ{;ǵys#]X
q%ޔg}G'>8<sߴacBfnisچD?bL<ؐ%}"&x! K>BrOoaƬȎdL=&D<)BVfaA,	S{w"T7a/ˈPdE}f@A,."oq־]7oa"{zvos3v$u֨<ThS2mu9o~)|20!#x$Av=={ZD)9pm*Ğ)IJ|		1Whp%%dtl;G\B%VҢ>yD[>^ٻ{P`L[<Tbb#jAK.کσ^;BTئk}8FAm:},EDzJ
C9u/%aG TAL%zۀ}pP32b##c.GrT5<u>{O7Fg3)/֬! x  