#!/bin/bash

function help {
   echo "Usage: Use for creating APTs. Make sure that current directory"
   echo "       contains prob.spec, input, and the skeleton file"

}

function cleanup {
    rm -rf *
    cd ..
    rm -rf $CURRENT_DIR
}

PROBSPEC_FILE="../prob.spec"
INPUT_FILE="../input"    
CURRENT_DIR="$(pwd)"
echo "Current dir is $CURRENT_DIR"

if [ -a $PROBSPEC_FILE ]
then
   echo "prob.spec file found..."
else 
   echo "ERROR: I am not able to find the prob.spec file."
   help
   exit
fi
   
 if [ -a $INPUT_FILE ]
 then
   echo "input file found...."
 else
      echo "ERROR: I am not able to find the input file."
      cleanup
      help
      exit
 fi


 
 SKELETON_CLASS="$(grep class $PROBSPEC_FILE | awk '{print $2}')"
 SKELETON_FILE=$SKELETON_CLASS.java
 
 if [ -a ../$SKELETON_FILE ]
 then
   echo "skeleton file $SKELETON_FILE found...."
 else
      echo "ERROR: I am not able to find skeleton file $SKELETON_FILE."
      help
      exit
 fi
 
 cp $PROBSPEC_FILE .
 cp $INPUT_FILE .
 cp ../$SKELETON_FILE .
 echo "creating tester file..."
 java MetaTester
 javac *.java 
 rm -f *.java $SKELETON_CLASS*  Meta* 
 echo "creating apt.jar...."
 jar -cf  apt.jar  *.class input 
 cp *.jar  ..
 rm -rf *
 cd ..
 rm -rf $CURRENT_DIR
 exit
 