
package jarmaker;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;


public class JarBuilder {
	private File myJarFile;
	private BufferedInputStream myInput;
	
	private void makeJar(File[] files) {

		byte[] myBuffer = new byte[1024];
		int size;
		File tFile;
		
		try {
			myJarFile =new File("weekly.jar");
			JarOutputStream jarOutput = new JarOutputStream(
					new FileOutputStream(myJarFile));
			
			for (int i = 0; i < files.length; i++) {
				if (files[i].isDirectory()) {
					JarEntry entry = new JarEntry(files[i].getName());
					entry.setSize(0);
					jarOutput.putNextEntry(entry);
					jarOutput.closeEntry();
				} else {
					JarEntry entry = new JarEntry(files[i].getName());
					try {
						myInput = new BufferedInputStream(new FileInputStream(
								files[i]));
					} catch (FileNotFoundException e) {
					}
					
					entry.setSize(files[i].length());
					jarOutput.putNextEntry(entry);
					
					while ((size = myInput.read(myBuffer)) != -1)
						jarOutput.write(myBuffer, 0, size);
					myInput.close();
					jarOutput.closeEntry();
				}
			}
			jarOutput.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	private String[] myFileList = {"EOFException.class, ParseTest.class",
			"TableMaker.class","TableMaker$Entry.class","Tester.class",
			"Tester$1.class","input"};
	
	public static void main(String[] args){
		
		File EOFException= new File("EOFException.class");
		File ParseTest = new File("ParseTest.class");
		File TableMaker1 = new File("TableMaker.class");
		File TableMaker2=new File("TableMaker$Entry.class");
		File Tester1 = new File("Tester.class");
		File Tester2 = new File("Tester$1.class");
		File input = new File("input");
		
		File[] array={EOFException,ParseTest,TableMaker1,
				TableMaker2,
				Tester1,Tester2,input};
		JarBuilder builder = new JarBuilder();
		builder.makeJar(array);
	}
}
