#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <student name> <class name> <class parent directory>"
    echo "e.g., $0 stu1 cps100 /afs/courses/cps"
    exit 2
fi

if [ ! -r $3/$2 ]
then
    echo "$3/$2 can't be read"
    exit 2
fi

studentName="$1"
className="$2"
classDir="$3"
permGroup="`whoami`:$className"

echo "Setting up student $studentName"
pts adduser $studentName $permGroup

#process project file
for projID in `ls $classDir/$className`
do
mkdir $classDir/$className/$projID/$studentName
#set permissions for project folder
fs setacl $classDir/$className/$projID/$studentName $permGroup none
fs setacl $classDir/$className/$projID/$studentName $studentName all
done
