#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <class name> <class parent directory> <student file>"
    echo "e.g., $0 cps100 /home/cps more_students.conf"
    exit 2
fi

if [ ! -r $2/$1 ]
then
    echo "$2/$1 can't be read"
    exit 2
fi
if [ ! -r $3 ] 
then
    echo "$3 can't be read" 
    exit 2 
fi 

classGroup="$1"
classDir="$2"
permGroup="`whoami`:$classGroup"
addFile="$3"

for studentID in `cat $addFile`
do
   echo "... $studentID"
   pts adduser $studentID $permGroup
   #process project file
   for projID in `ls $classDir/$classGroup`
   do
     mkdir $classDir/$classGroup/$projID/$studentID
     #set permissions for student folder
     fs setacl $classDir/$classGroup/$projID/$studentID $permGroup none
     fs setacl $classDir/$classGroup/$projID/$studentID $studentID all
   done
done
