#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 1 ]
then
    echo "usage: $0 <project directory>"
    echo "e.g., $0 /afs/courses/cps/cps100/proj1"
    exit 2
fi

projDir="$1.project"

if [ ! -r $1 ]
then
    echo "$1 not a valid project path"
    exit 2
fi

echo "project folder $1 is being DELETED" 
do 
  /usr/bin/rm -rf $projDir
done
