#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <project name> <course name> <files source directory>"
    echo "e.g., $0 project1 cps100 /projects/proj1"
    exit 2
fi

if [ ! -r $3 ]
then
    echo "$3 can't be read"
    exit 2
fi

projName="$1.project"
courseName="$2"
projGroup="`whoami`:$courseName"
projDir="$3"

#check for CVSROOT
if [ $CVSROOT ]
then
    .
else
    echo "no CVSROOT specified"
fi

cd $projDir
echo "Setting up $1"
#set up the repository
cvs import -m "Skeleton files for $projName" $courseName/$projName/.skeleton skeleton start >> /dev/null

#change the permissions
fs setacl $CVSROOT/$courseName/$projName/.skeleton $projGroup rl

