#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <student> <class name> <class parent directory>"
    echo "e.g., $0 stu1 cps100 /afs/courses/cps"
    exit 2
fi

if [ ! -r $3/$2 ]
then
    echo "$3/$2 can't be read"
    exit 2
fi

studentName="$1"
courseName="$2"
courseDir="$3"
permGroup="`whoami`:$courseName"

#process project file
echo "deleting student $studentName"
for projID in `ls $courseDir/$courseName`
do
  #fs setacl $courseDir/$courseName/$projID/$studentName $studentName none
  /usr/bin/rm -rf $courseDir/$courseName/$projID/$studentName
done

#remove student from permission class group
pts removeuser $studentName $permGroup 
