#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <class name> <class parent directory> <student file>"
    echo "e.g., $0 cps100 /afs/courses/cps remove_students.conf"
    exit 2
fi

if [ ! -r $2/$1 ]
then
    echo "$2/$1 can't be read"
    exit 2
fi

courseName="$1"
courseDir="$2"
permGroup="`whoami`:$courseName"
removeFile="$3"

#check for student file 
if [ ! -r $removeFile ]
then 
    echo "no $removeFile found"
    exit 2
fi   

#process project file
for studentID in `cat $removeFile`
do
 echo "deleting student $studentID"
 for projID in `ls $courseDir/$courseName`
 do
  /usr/bin/rm -rf $courseDir/$courseName/$projID/$studentID
 done
 #remove student from permission class group
 pts removeuser $studentID $permGroup 
done
