#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <class name> <class parent directory> <student file>"
    echo "e.g., $0 cps100 /afs/courses/cps/ cps100students.conf"
    exit 2
fi

courseName="$1"
rootFolder="$2"
projectFile="projects.conf"
studentFile="$3"
permGroup="`whoami`:$courseName"

#check for student file 
if [ ! -r $studentFile ]
then
    echo "no $studentFile found"
    exit 2
fi

if [ ! -r $rootFolder ]
then
    echo "Cannot access root folder specified"
    exit 2
fi

#create class group and give permisssion for course folder
pts creategroup $permGroup
mkdir $rootFolder/$courseName
fs setacl $rootFolder/$courseName $permGroup l

#process project file
if [ -r $projectFile ] 
then
for projID in `cat $projectFile`
do
  echo "setting up folders for $projID"
  mkdir $rootFolder/$courseName/$projID
  #set permissions for project folder
  fs setacl $rootFolder/$courseName/$projID $permGroup l 
done
fi

#process student file
for studentID in `cat $studentFile`
do
  pts adduser $studentID $permGroup 
done

#add the students folder and file to the course folder
newStudentFile="students.conf"
mkdir $rootFolder/$courseName/"students"
`cat $studentFile > $rootFolder/$courseName/"students"/$newStudentFile`
