#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 5 ]
then
    echo "usage: $0 <course name> <project name> <course parent folder> <group size> <student file>"
    echo "e.g., $0 cps100 proj1 /afs/courses/cps/ 2 student_groups.conf"
    exit 2
fi

groupProj="$2.project"
courseName="$1"
rootFolder="$3"
groupFile="$5"
permGroup="`whoami`:$courseName"

#check for group file
if [ ! -r $groupFile ]
then
    echo "no $groupFile found"
    exit 2
fi

if [ ! -r $rootFolder ] 
then 
    echo "Cannot access root folder specified"
    exit 2 
fi 

#process group file
count=1
studentCount=$4
myDir="empty"
for studentID in `cat $groupFile`
do
   if [ $studentCount = $4 ]
   then
     groupID="$1.$2.group.no.$count.size.$4"
     echo "setting up group $groupID" 
     myGroup="`whoami`:$groupID"
     pts creategroup $myGroup
     count=`expr $count + 1`
   fi
   pts adduser $studentID $myGroup
   if [ $studentCount = $4 ]
   then
     myDir="$studentID"
   else 
     myDir="$myDir.$studentID"
   fi
   studentCount=`expr $studentCount - 1`
   if [ $studentCount = 0 ]
   then
     #final group directory user1.user2.user3
     mkdir $rootFolder/$courseName/$groupProj/$myDir
     #set permissions for group folder
     fs setacl $rootFolder/$courseName/$groupProj/$myDir $myGroup all
     fs setacl $rootFolder/$courseName/$groupProj/$myDir "`whoami`:$courseName" none
     studentCount=$4
   fi
done

