#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 2 ]
then
    echo "usage: $0 <project name> <course name> <course root folder>"
    echo "e.g., $0 project1 cps100 /afs/courses/cps"
    echo "e.g., $0 classwork/project1 cps100 /afs/courses/cps"    
    exit 2
fi

if [ ! -r $3 ]
then
    echo "$3 can't be read"
    exit 2
fi

projName="$1.project"
courseName="$2"
projGroup="`whoami`:$courseName"
courseDir="$3"

echo "Setting up $1"
mkdir -p $courseDir/$courseName/$projName
mkdir $courseDir/$courseName/$projName/.skeleton
fs setacl $courseDir/$courseName/$projName $projGroup l
fs setacl $courseDir/$courseName/$projName/.skeleton $projGroup rl

