#!/usr/bin/sh
############################################################################
# part of the Duke Ambient Project
############################################################################

#check if project name and directory are specified
if [ $# -lt 3 ]
then
    echo "usage: $0 <class name> <project name> <course parent folder>"
    echo "e.g., $0 cps100 proj2 /afs/courses/cps/"
    exit 2
fi

courseName="$1"
rootFolder="$3"
studentFile="students.conf"
permGroup="`whoami`:$courseName"
projID="$2.project"

#check for students.conf 
if [ ! -r $rootFolder/$courseName/"students"/$studentFile ]
then
    echo "no $studentFile found"
    exit 2
fi

if [ ! -r $rootFolder ]
then
    echo "Cannot access root folder specified"
    exit 2
fi

#process the student file
for studentID in `cat $rootFolder/$courseName/"students"/$studentFile`
do
    echo ".. $studentID"
    mkdir $rootFolder/$courseName/$projID/$studentID
    #change the permissions
    fs setacl $rootFolder/$courseName/$projID/$studentID $permGroup none
    fs setacl $rootFolder/$courseName/$projID/$studentID $studentID all  
done

