/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * LibraryFilter
 * org.eclipse.jdt.internal.ui.filters
 *******************************************************************************/
package edu.duke.ambient.ui;
/**
 * @author Duke Curious 2004
 */
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/**
 * The LibraryFilter is a filter used to determine whether
 * a Java library is shown
 */
public class AmbientLibraryFilter extends ViewerFilter {

	/* (non-Javadoc)
	 * Method declared on ViewerFilter.
	 */
	public boolean select(
		Viewer viewer,
		Object parentElement,
		Object element) {
		
		if (element instanceof AmbientClassPathContainer)
			return false;
		if (element instanceof IPackageFragmentRoot) {
			IPackageFragmentRoot root = (IPackageFragmentRoot) element;
			if (root.isArchive()) {
				// don't filter out JARs contained in the project itself
				IResource resource = root.getResource();
				if (resource != null) {
					IProject jarProject = resource.getProject();
					IProject container = root.getJavaProject().getProject();
					return container.equals(jarProject);
				}
				return false;
			}
		}
		return true;
	}
}
