/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original PackagesFrameSource in
 * org.eclipse.jdt.internal.ui.packageview
 *******************************************************************************/

package edu.duke.ambient.ui;
/**
 * @author Duke Curious 2004
 */
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.TreeViewerFrameSource;

public class AmbientPackagesFrameSource extends TreeViewerFrameSource {
	private AmbientPackageExplorer fPackagesExplorer;
	
	public AmbientPackagesFrameSource(AmbientPackageExplorer explorer) {
		super(explorer.getViewer());
		fPackagesExplorer= explorer;
	}

	protected TreeFrame createFrame(Object input) {
		TreeFrame frame = super.createFrame(input);
		frame.setName(fPackagesExplorer.getFrameName(input));
		frame.setToolTipText(fPackagesExplorer.getToolTipText(input));
		return frame;
	}

	/**
	 * Also updates the title of the packages explorer
	 */
	protected void frameChanged(TreeFrame frame) {
		super.frameChanged(frame);
		fPackagesExplorer.updateTitle();
	}

}
