/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original CollapseAllAction in
 * org.eclipse.jdt.internal.ui.packageview
 *******************************************************************************/
package edu.duke.ambient.ui.actions;

import org.eclipse.jdt.internal.ui.IJavaHelpContextIds;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.help.WorkbenchHelp;

import edu.duke.ambient.ui.AmbientPackageExplorer;

/**
 * Collapse all nodes.
 */
public class AmbientCollapseAllAction extends Action {
	
	private AmbientPackageExplorer fPackageExplorer;
	
	public AmbientCollapseAllAction(AmbientPackageExplorer part) {
		super(PackagesMessages.getString("CollapseAllAction.label")); //$NON-NLS-1$
		setDescription(PackagesMessages.getString("CollapseAllAction.description")); //$NON-NLS-1$
		setToolTipText(PackagesMessages.getString("CollapseAllAction.tooltip")); //$NON-NLS-1$
		JavaPluginImages.setLocalImageDescriptors(this, "collapseall.gif"); //$NON-NLS-1$
		
		fPackageExplorer= part;
		WorkbenchHelp.setHelp(this, IJavaHelpContextIds.COLLAPSE_ALL_ACTION);
	}
 
	public void run() { 
		fPackageExplorer.collapseAll();
	}
}
