/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original GotoResourceAction in
 * org.eclipse.jdt.internal.ui.packageview
 *******************************************************************************/
package edu.duke.ambient.ui.actions;
/**
 * @author Duke Curious 2004
 */
import org.eclipse.swt.widgets.Shell;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

import org.eclipse.core.runtime.CoreException;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;

import org.eclipse.ui.dialogs.ResourceListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;

import org.eclipse.jdt.internal.ui.IJavaHelpContextIds;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;

import edu.duke.ambient.ui.AmbientPackageExplorer;

public class AmbientGotoResourceAction extends Action {

	private AmbientPackageExplorer fPackageExplorer;

	private static class GotoResourceDialog extends ResourceListSelectionDialog {
		private IJavaModel fJavaModel;
		private Viewer fViewer;
		private ViewerFilter[] fFilters;
		public GotoResourceDialog(Shell parentShell, IContainer container, StructuredViewer viewer) {
			super(parentShell, container, IResource.FILE | IResource.FOLDER | IResource.PROJECT);
			fJavaModel= JavaCore.create(ResourcesPlugin.getWorkspace().getRoot());
			fViewer= viewer;
			fFilters= viewer.getFilters();
			setTitle(PackagesMessages.getString("GotoResource.dialog.title")); //$NON-NLS-1$
			WorkbenchHelp.setHelp(parentShell, IJavaHelpContextIds.GOTO_RESOURCE_DIALOG);
		}
		protected boolean select(IResource resource) {
			IProject project= resource.getProject();
			try {
				if (project.getNature(JavaCore.NATURE_ID) != null)
					return fJavaModel.contains(resource);
			} catch (CoreException e) {
				// do nothing. Consider resource;
			}
			return true;
		}
	}

	public AmbientGotoResourceAction(AmbientPackageExplorer explorer) {
		setText(PackagesMessages.getString("GotoResource.action.label")); //$NON-NLS-1$
		WorkbenchHelp.setHelp(this, IJavaHelpContextIds.GOTO_RESOURCE_ACTION);
		fPackageExplorer= explorer;
	}
	
	public void run() {
		TreeViewer viewer= fPackageExplorer.getViewer();
		GotoResourceDialog dialog= new GotoResourceDialog(fPackageExplorer.getSite().getShell(), 
			ResourcesPlugin.getWorkspace().getRoot(), viewer);
	 	dialog.open();
	 	Object[] result = dialog.getResult();
	 	if (result == null || result.length == 0 || !(result[0] instanceof IResource))
	 		return;
	 	StructuredSelection selection= null;
		IJavaElement element = JavaCore.create((IResource)result[0]);
		if (element != null && element.exists())
			selection= new StructuredSelection(element);
		else 
			selection= new StructuredSelection(result[0]);
		viewer.setSelection(selection, true);
	}	
}
