/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.actions;
/**
 * @author Duke Curious 2004
 */
import java.net.URL;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

import edu.duke.eclipse.weekly.ui.actions.WeeklyRunApplicationAction;

public class AmbientRunActionDelegate extends Action implements IMenuCreator, IWorkbenchWindowPulldownDelegate2 {
	private IWorkbenchWindow window;
	
	private Menu AmbientRunMenu = null;
	private AmbientRunAction applicationAction = null;
	private AmbientRunAction applicationCLAAction = null;
	private AmbientRunAction appletAction = null;
	private WeeklyRunApplicationAction aptAction = null;
	private AmbientRunAction applicationDebugAction = null;
	private AmbientRunAction applicationDebugCLAAction = null;
	private AmbientRunAction appletDebugAction = null;
		
	/**
	 * The constructor.
	 */
	public AmbientRunActionDelegate() {
		super();
		URL url;
		Path iPath;  //the path for icons.
		
		//set up the action
		applicationAction = new AmbientRunApplicationAction();
		applicationAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		applicationAction.setText("Run Application");
		applicationAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientRunApplicationCommand");
		//set up the icon
		iPath = new Path("icons/AmbientRunApplication.gif");
        url = WorkbenchPlugin.getDefault().find(iPath);
		applicationAction.setImageDescriptor(ImageDescriptor.createFromURL(url));

		applicationCLAAction = new AmbientRunApplicationCLAAction();
		applicationCLAAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		applicationCLAAction.setText("Run Application w/ Command Line Arguments");
		applicationCLAAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientRunApplicationCLACommand");
		//set up the icon
		iPath = new Path("icons/AmbientRunApplication.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		applicationCLAAction.setImageDescriptor(ImageDescriptor.createFromURL(url));
				
		appletAction= new AmbientRunAppletAction();
		appletAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		appletAction.setText("Run Applet");
		appletAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientRunAppletCommand");
		//set up the icon
		iPath = new Path("icons/AmbientRunApplet.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		appletAction.setImageDescriptor(ImageDescriptor.createFromURL(url));

		aptAction = new WeeklyRunApplicationAction();
		aptAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		aptAction.setText("Run APT");
		aptAction.setActionDefinitionId("edu.duke.eclipse.weekly.ui.AmbientRunApplicationCommand");
		//set up the icon
		iPath = new Path("icons/weekly.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		aptAction.setImageDescriptor(ImageDescriptor.createFromURL(url));		

		//set up the action
		applicationDebugAction = new AmbientDebugApplicationAction();
		applicationDebugAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		applicationDebugAction.setText("Debug Application");
		applicationDebugAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientDebugApplicationCommand");
		//set up the icon
		iPath = new Path("icons/AmbientDebugApplication.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		applicationDebugAction.setImageDescriptor(ImageDescriptor.createFromURL(url));
		
		//set up the action
		applicationDebugCLAAction = new AmbientDebugApplicationCLAAction();
		applicationDebugCLAAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		applicationDebugCLAAction.setText("Debug Application w/ Command Line Arguments");
		applicationDebugCLAAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientDebugApplicationCLACommand");
		//set up the icon
		iPath = new Path("icons/AmbientDebugApplication.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		applicationDebugCLAAction.setImageDescriptor(ImageDescriptor.createFromURL(url));
		
		appletDebugAction= new AmbientDebugAppletAction();
		appletDebugAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		appletDebugAction.setText("Debug Applet");
		appletDebugAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientDebugAppletCommand");
		//set up the icon
		iPath = new Path("icons/AmbientDebugApplet.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);
		appletDebugAction.setImageDescriptor(ImageDescriptor.createFromURL(url));

	}

	public void run(IAction action) {
		applicationAction.run();
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowPulldownDelegate#getMenu(org.eclipse.swt.widgets.Control)
	 */
	public Menu getMenu(Control parent) {
		Menu AmbientRunMenu = new Menu(parent);
		fillMenu(AmbientRunMenu);
		return AmbientRunMenu;
	}



	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Menu)
	 */
	public Menu getMenu(Menu parent) {
		Menu AmbientRunMenu = new Menu(parent);
		fillMenu(AmbientRunMenu);
		return AmbientRunMenu;
	}
	
	/*
	 * Adds the two actions to a new menu. 
	 * @param menu
	 */
	private void fillMenu(Menu menu) {
		ActionContributionItem applicationItem = 
			new ActionContributionItem(applicationAction);
		ActionContributionItem applicationCLAItem = 
					new ActionContributionItem(applicationCLAAction);
		ActionContributionItem appletItem =
			new ActionContributionItem(appletAction);
		ActionContributionItem aptItem =
			new ActionContributionItem(aptAction);
		ActionContributionItem applicationDebugItem = 
					new ActionContributionItem(applicationDebugAction);
		ActionContributionItem applicationDebugCLAItem = 
					new ActionContributionItem(applicationDebugCLAAction);
		ActionContributionItem appletDebugItem =
					new ActionContributionItem(appletDebugAction);
							
		applicationItem.fill(menu, -1);
		applicationCLAItem.fill(menu, -1);
		appletItem.fill(menu, -1);
		aptItem.fill(menu, -1);
		applicationDebugItem.fill(menu, -1);
		applicationDebugCLAItem.fill(menu, -1);
		appletDebugItem.fill(menu, -1);
		
	}
}
