/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class uses code from the classes CVSAction, TeamAction, and 
 * WorkspaceAction in org.eclipse.team.internal.ccvs.ui.actions
 *******************************************************************************/

package edu.duke.ambient.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.HistoryView;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import edu.duke.ambient.AmbientPlugin;

/**
 * @author Duke Curious 2004
 */

public class AmbientShowResourceInHistoryAction
	extends WorkspaceAction
	implements IWorkbenchWindowActionDelegate {

	protected IStructuredSelection fSelection;

	/**
	 * default constructor
	 *
	 */
	public AmbientShowResourceInHistoryAction() {
		fSelection = StructuredSelection.EMPTY;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		super.dispose();

	}

	/*
	 * @see IActionDelegate#run(IAction)
	 */
	public void execute(IAction action)
		throws InterruptedException, InvocationTargetException {
		run(new IRunnableWithProgress() {
			public void run(IProgressMonitor monitor)
				throws InvocationTargetException {
				IResource[] resources = getResources();
				if (resources.length != 1) {
					IEditorPart currentEditor = AmbientPlugin.getWorkbenchPage().getActiveEditor();
					if (currentEditor == null)
						return;
					CompilationUnit cu = null;
					if (currentEditor instanceof CompilationUnitEditor)
						cu = (CompilationUnit) ((CompilationUnitEditor)(AmbientPlugin.getWorkbenchPage().getActiveEditor())).getViewPartInput();
					if (cu == null)
						return;
					resources = new IResource[] {cu.getResource()};
				}
				HistoryView view = (HistoryView) showView(HistoryView.VIEW_ID);
				if (view != null) {
					view.showHistory(resources[0],true);//TODO added true
				}
			}
		}, false /* cancelable */
		, PROGRESS_BUSYCURSOR);
	}

	/**
	 * Override to ensure that the selected resources so not overlap.
	 * This method assumes that all actions are deep.
	 * 
	 * @see org.eclipse.team.internal.ui.actions.WorkspaceAction#getSelectedResources()
	 */
	protected IResource[] getResources() {
		return getNonOverlapping(getSelectedResources());
	}

	/**
	 * Returns the selected resources.
	 * 
	 * @return the selected resources
	 */
	protected IResource[] getSelectedResources() {
		ArrayList resources = null;
		if (!fSelection.isEmpty()) {
			resources = new ArrayList();
			Iterator elements = ((IStructuredSelection) fSelection).iterator();
			while (elements.hasNext()) {
				Object next = elements.next();
				if (next instanceof IResource) {
					resources.add(next);
					continue;
				}
				if (next instanceof IAdaptable) {
					IAdaptable a = (IAdaptable) next;
					Object adapter = a.getAdapter(IResource.class);
					if (adapter instanceof IResource) {
						resources.add(adapter);
						continue;
					}
				}
			}
		}
		if (resources != null && !resources.isEmpty()) {
			IResource[] result = new IResource[resources.size()];
			resources.toArray(result);
			return result;
		}
		return new IResource[0];
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow window) {
		// nothing to do here

	}

	protected boolean isEnabled() throws TeamException {
		return true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	/*
	 * Method declared on IActionDelegate.
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			fSelection = (IStructuredSelection) selection;
			if (action != null) {
				setActionEnablement(action);
			}
		}
	}

	/**
	 * Override to ensure that the sync info is available before performing the
	 * real <code>isEnabled()</code> test.
	 * 
	 * @see org.eclipse.team.internal.ui.actions.TeamAction#setActionEnablement(IAction)
	 */
	protected void setActionEnablement(IAction action) {
		try {
			boolean requires = requiresLocalSyncInfo();
			if (!requires
				|| (requires && isSyncInfoLoaded(getSelectedResources()))) {
				super.setActionEnablement(action);
			} else {
				// If the sync info is not loaded, enable the menu item
				// Performing the action will ensure that the action should really
				// be enabled before anything else is done
				action.setEnabled(true);
			}
		} catch (CVSException e) {
			// We couldn't determine if the sync info was loaded.
			// Enable the action so that performing the action will
			// reveal the error to the user.
			action.setEnabled(true);
		}
	}
}
