/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.actions;
/**
 * @author Duke Curious 2004
 */
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;

import edu.duke.ambient.AmbientPlugin;

/**
 * @see IWorkbenchWindowActionDelegate
 */
public class AmbientSwitchPerspectiveAction
	implements IWorkbenchWindowActionDelegate {
	public static AmbientSwitchPerspectiveAction staticInstance =
		new AmbientSwitchPerspectiveAction();
	/**
	 */
	public AmbientSwitchPerspectiveAction() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		WorkbenchPage page = AmbientPlugin.getWorkbenchPage();
		PerspectiveDescriptor desc =
			(PerspectiveDescriptor) (AmbientPlugin
				.getDefault()
				.getWorkbench()
				.getPerspectiveRegistry()
				.findPerspectiveWithId("edu.duke.ambient.ui.PerspectiveAmbient"));
		page.setPerspective(desc);

		IActionSetDescriptor[] actionSetArray = page.getActionSets();
		IActionSetDescriptor[] newActionSetArray = new IActionSetDescriptor[2];
		int index = 0;
		for (int i = 0; i < actionSetArray.length; i++) {
			if (actionSetArray[i].getLabel().equalsIgnoreCase("Ambient Menu")) {
				newActionSetArray[index] = actionSetArray[i];
				index++;
			}
			else if (actionSetArray[i]
				.getLabel()
				.equalsIgnoreCase("Ambient Toolbar")) {
				newActionSetArray[index] = actionSetArray[i];
				index++;
			}
			else if (actionSetArray[i]
				.getLabel()
				.equalsIgnoreCase("Help")) {
				newActionSetArray[index] = actionSetArray[i];
				index++;
			}
		}
		Perspective pers = page.findPerspective(desc);
		}

	/**
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
	}
}
