/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * This class is edited from the original ToggleLinkingAction in
 * org.eclipse.jdt.internal.ui.packageview
 *******************************************************************************/
package edu.duke.ambient.ui.actions;
/**
 * @author Duke Curious 2004
 */
import org.eclipse.jdt.internal.ui.IJavaHelpContextIds;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.help.WorkbenchHelp;

import edu.duke.ambient.ui.AmbientPackageExplorer;


/**
 * This action toggles whether this package explorer links its selection to the active
 * editor.
 * 
 * @since 2.1
 */
public class AmbientToggleLinkingAction extends Action {
	
	AmbientPackageExplorer fPackageExplorerPart;
	
	/**
	 * Constructs a new action.
	 */
	public AmbientToggleLinkingAction(AmbientPackageExplorer explorer) {
		super(PackagesMessages.getString("ToggleLinkingAction.label")); //$NON-NLS-1$
		setDescription(PackagesMessages.getString("ToggleLinkingAction.description")); //$NON-NLS-1$
		setToolTipText(PackagesMessages.getString("ToggleLinkingAction.tooltip")); //$NON-NLS-1$
		JavaPluginImages.setLocalImageDescriptors(this, "synced.gif"); //$NON-NLS-1$		
		WorkbenchHelp.setHelp(this, IJavaHelpContextIds.LINK_EDITOR_ACTION);

		setChecked(explorer.isLinkingEnabled());
		fPackageExplorerPart= explorer;
	}

	/**
	 * Runs the action.
	 */
	public void run() {
		fPackageExplorerPart.setLinkingEnabled(isChecked());
	}

}
