/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

import edu.duke.ambient.ui.checkin.pages.AmbientExportResourcesPage;

/**
 * @author Del Myers, Frank Mueller, Modified by Peter Gebhard
 * Duke CURIOUS Program, Summer 2004
 *
 * An abstract class to support checking out of projects. This class doesn't support any specific functionality for either.
 * It is upto a subclass to implement the actual functionality.
 * 
 * Direct known subclasses: CheckoutFullAction, CheckoutBasicAction
 */


public abstract class CheckoutAction
	extends AmbientSelectionAction {

	
	protected String arguments;

	public CheckoutAction() {
		super();
	}

	public void init(IWorkbenchWindow window) {
		//do nothing
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		//no need to dispose anything
	}

	public void run() {
		IWorkbenchWindow wb =
			PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		if (wb != null) {
			IWorkbenchPage page = wb.getActivePage();
			if (page != null) {
				ISelection selection = page.getSelection();
				//update the selection.
				selectionChanged(null, selection);
			}
		}

		AmbientExportResourcesPage.saveDirtyEditors();
		//run the action as null; there is no other action to run besides this one.
		run(null);
	}

	public void run(IAction action) {
		//do nothing
	}

	/**
	 * @return
	 */
	protected String getArguments() {
		AmbientArgumentsDialog dialog = new AmbientArgumentsDialog(getShell());
		if (dialog.open() == AmbientArgumentsDialog.OK)
			return dialog.getArguments();
		return null;
	}

	protected void reportCreatingConfiguration(final CoreException exception) {
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				ErrorDialog.openError(getShell(), LauncherMessages.getString("JavaApplicationLaunchShortcut.Error_Launching_1"), LauncherMessages.getString("JavaApplicationLaunchShortcut.Exception"), exception.getStatus()); //new Status(IStatus.ERROR, JDIDebugUIPlugin.getUniqueIdentifier(), IStatus.ERROR, exception.getMessage(), exception)); //$NON-NLS-1$ //$NON-NLS-2$
			}
		});
	}


	/**
	 * Convenience method to get the window that owns this action's Shell.
	 */
	protected Shell getShell() {
		return JDIDebugUIPlugin.getActiveWorkbenchShell();
	}

}
