/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.actions;
/**
 * @author Duke Curious 2004
 */
import java.net.URL;

import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CheckoutActionDelegate extends Action implements IMenuCreator, IWorkbenchWindowPulldownDelegate2 {
	private IWorkbenchWindow window;
	
	private Menu CheckoutMenu = null;
	private CheckoutBasicAction basicAction = null;
	private CheckoutFullAction fullAction = null;
		
	/**
	 * The constructor.
	 */
	public CheckoutActionDelegate() {
		super();
		URL url;
		Path iPath;  //the path for icons.
		
		//set up the action
		basicAction = new CheckoutBasicAction();
		basicAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		basicAction.setText("Checkout Basic Project");
		basicAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientCheckoutBasicCommand");
		//set up the icon
		iPath = new Path("icons/AmbientCheckoutBasic.gif");
        url = WorkbenchPlugin.getDefault().find(iPath);
		basicAction.setImageDescriptor(ImageDescriptor.createFromURL(url));

		fullAction = new CheckoutFullAction();
		fullAction.init(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
		fullAction.setText("Checkout Project");
		fullAction.setActionDefinitionId("edu.duke.ambient.ui.AmbientCheckoutCommand");
		//set up the icon
		iPath = new Path("icons/AmbientCheckout.gif");
		url = WorkbenchPlugin.getDefault().find(iPath);//TODO: same as above
		fullAction.setImageDescriptor(ImageDescriptor.createFromURL(url));

	}

	public void run(IAction action) {
		fullAction.run(action);
	}

	public void selectionChanged(IAction action, ISelection selection) {
	}

	public void dispose() {
	}

	public void init(IWorkbenchWindow window) {
		this.window = window;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchWindowPulldownDelegate#getMenu(org.eclipse.swt.widgets.Control)
	 */
	public Menu getMenu(Control parent) {
		Menu AmbientRunMenu = new Menu(parent);
		fillMenu(AmbientRunMenu);
		return AmbientRunMenu;
	}



	/* (non-Javadoc)
	 * @see org.eclipse.jface.action.IMenuCreator#getMenu(org.eclipse.swt.widgets.Menu)
	 */
	public Menu getMenu(Menu parent) {
		Menu AmbientRunMenu = new Menu(parent);
		fillMenu(AmbientRunMenu);
		return AmbientRunMenu;
	}
	
	/*
	 * Adds the two actions to a new menu. 
	 * @param menu
	 */
	private void fillMenu(Menu menu) {
		ActionContributionItem fullItem = 
			new ActionContributionItem(fullAction);
		ActionContributionItem basicItem = 
			new ActionContributionItem(basicAction);
							
		fullItem.fill(menu, -1);
		basicItem.fill(menu, -1);		
	}
}
