/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * RemoteContentProvider
 * org.eclipse.team.internal.ccvs.ui.model
 *******************************************************************************/
package edu.duke.ambient.ui.checkin;

import java.util.Comparator;
import java.util.TreeMap;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.model.WorkbenchContentProvider;

import edu.duke.ambient.AmbientGlobals;

/**
 * Extension to the generic workbench content provider mechanism
 * to lazily determine whether an element has children.  That is,
 * children for an element aren't fetched until the user clicks
 * on the tree expansion box.
 */
public class AmbientRemoteContentProvider extends WorkbenchContentProvider {
	IWorkingSet workingSet;
	private final boolean DEBUG = false;
	private final String myCvsRootStr = "CVSROOT";
	
	private final String[] myFilterReq = 
	{myCvsRootStr,AmbientGlobals.STUDENT_CONFIG_DIR};

	
	public boolean hasChildren(Object element) {
		if (DEBUG) {
			System.out.println("In AmbientRemoteContentProvider ");
			System.out.println("    hasChildren() was called");
		}

		if (element == null) {
			return false;
		}
		
		try{
			String name = ((ICVSRemoteResource)element).getName();
			if(name.endsWith(AmbientGlobals.PROJECT_EXT)){
				return false;
			}
		}catch(Exception e){
			
		}
		return true;
	}

	/**
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	public Object[] getChildren(Object parentElement) {
		Object[] children = super.getChildren(parentElement);
		TreeMap map = new TreeMap(new Comp());
		String name = null;
		for (int k = 0; k < children.length; k++) {
			name = ((ICVSRemoteResource) children[k]).getName();
			if (name.equalsIgnoreCase(AmbientGlobals.SKELETON)){
				return null;
			}
			
			if (!name.startsWith(".")){
				map.put(name,children[k]);
			}
		}
		return filter(map,myFilterReq);
	}

	public void setWorkingSet(IWorkingSet workingSet) {
		this.workingSet = workingSet;
	}

	public IWorkingSet getWorkingSet() {
		return workingSet;
	}
	
	private Object[] filter(TreeMap children, Object[] omit){
	
		for (int k=0; k<omit.length;k++){ 
			if (children.containsKey(omit[k])){
				children.remove(omit[k]);
			}
		}
		
		return children.values().toArray();
	}
	
	class Comp implements Comparator{

		/* (non-Javadoc)
		 * @see java.util.Comparator#compare(java.lang.Object, java.lang.Object)
		 */
		public int compare(Object arg0, Object arg1) {
			return ((String)arg0).compareTo((String)arg1);
		}
		
	}
}
