package edu.duke.ambient.ui.checkin;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

import edu.duke.ambient.AmbientGlobals;

public class AmbientTreeLabelProvider implements ILabelProvider {

	public Image getImage(Object element) {
		String name = null;
		if (element instanceof IResource){
			name = ((IResource) element).getName();
		}else if(element instanceof ICVSRemoteResource){
			name = ((ICVSRemoteResource)element).getName();
		}
		
		if (name.endsWith(AmbientGlobals.PROJECT_EXT)) {
			return PlatformUI.getWorkbench().getSharedImages().getImage(
					org.eclipse.ui.ide.IDE.SharedImages.IMG_OBJ_PROJECT);
		} else {
			return PlatformUI.getWorkbench().getSharedImages().getImage(
					ISharedImages.IMG_OBJ_FOLDER);
		}

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ILabelProvider#getText(java.lang.Object)
	 */
	public String getText(Object element) {
			String name = null;
			if (element instanceof IResource){
				name = ((IResource) element).getName();
			}else if(element instanceof ICVSRemoteResource){
				name = ((ICVSRemoteResource)element).getName();
			}
			
			try{
			if (name.endsWith(AmbientGlobals.PROJECT_EXT)) {
				return name.split(AmbientGlobals.PROJECT_EXT)[0];
			} else {
				return name;
			}
			}catch(Exception e){
				return name;
			}
	
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object,
	 *      java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {

	}

}
