/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
package edu.duke.ambient.ui.checkin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

import edu.duke.ambient.ui.actions.AmbientSwitchPerspectiveAction;
import edu.duke.ambient.ui.checkin.pages.AmbientCheckoutPage;
import edu.duke.ambient.ui.wizards.AmbientCheckoutWizard;


public class CheckoutBasic implements IWorkbenchWindowActionDelegate {
	
	public CheckoutBasic() {}

	/**
	 * @see IWorkbenchWindowActionDelegate#run
	 */
	public void run(IAction action) {
		//open project submit wizard
		try {
			IWizard wizard = new AmbientCheckoutWizard(AmbientCheckoutPage.BASIC_TYPE);
			WizardDialog dialog =
				new WizardDialog(
					PlatformUI
						.getWorkbench()
						.getActiveWorkbenchWindow()
						.getShell(),
					wizard);
			dialog.open();
			AmbientSwitchPerspectiveAction.staticInstance.run(null);
		} catch (Exception e) {
			// nothing
		}
	}

	/**
	 * 
	 * @see IWorkbenchWindowActionDelegate#selectionChanged
	 */
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * 
	 * @see IWorkbenchWindowActionDelegate#dispose
	 */
	public void dispose() {
	}

	/**
	 * 
	 * @see IWorkbenchWindowActionDelegate#init
	 */
	public void init(IWorkbenchWindow window) {
	}
}
