/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/

package edu.duke.ambient.ui.checkin;

import java.util.Vector;

/**
 * 
 * @author dartmouth
 * Gets a  string with the format foo1.foo2...fooxxx, and creates an array with the
 * members foo1, foo2, etc. 
 */

public class NameReader {
	char SEP = '.';
	private String INPUT ;
	private Vector MEMBERS;
	
	public NameReader(){
		MEMBERS = new Vector();
	}
	
	public void processString(String str){
		INPUT   = str;
		MEMBERS = getMembers();
	}
	
	public boolean hasMember(String member){
		for (int k=0;k<MEMBERS.size();k++){
			if (((String)MEMBERS.get(k)).equalsIgnoreCase(member)){
				return true;
			}
		}
		return false;
	}
	
	public Vector getMembers(){
		int index = -1;
		Vector outVect = new Vector();
		boolean goFlag = true;
		
		while(goFlag){
			index = INPUT.indexOf(SEP);
			if (index == -1){
				goFlag = false;
				outVect.addElement(INPUT);
			}else {
				outVect.addElement(INPUT.substring(0,index));
				INPUT = INPUT.substring(index+1);
			}
		}
		
		return outVect;
	}
	
	public final static  void main(String[] args){
		NameReader reader = new NameReader();
		reader.processString("pkn.vid2.aladdin.alibaba");
		System.out.println("has pkn " + reader.hasMember("pkn"));
		System.out.println("has alikbaba " + reader.hasMember("alibaba"));
		System.out.println("has foo " + reader.hasMember("foo"));
	}
}
