/*******************************************************************************
 * Copyright (c) 2004 Duke University
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Common Public License v1.0 which accompanies
 * this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 *  
 ******************************************************************************/
package edu.duke.ambient.ui.checkin;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.ui.subscriber.WorkspaceCommitOperation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;;

public class Shared {
	private IProject PROJ;
	private IResource[] resourcesToCommit = new IResource[100000];
	private ICVSResource remoteRoot;
	private int numResources;
	private final boolean DEBUG = true;

	public Shared(IProject project) {
		Session ss = null;
		Command com = null;
		WorkspaceCommitOperation op = null;
		try {
			remoteRoot = CVSWorkspaceRoot.getRemoteResourceFor(project);

		} catch (TeamException e) {
			if (DEBUG) {
				e.printStackTrace();
			}
		}
		this.PROJ = project;
	}

	public Shared() {

	}

	public IResource[] getWorkspaceResources() {
		IResource[] res = new IResource[1];
		if (PROJ.exists()) {
			res[0] = PROJ;
			return res;
		}
		return null;
	}

	public void deleteResources() {
		try {
			IResource[] children = PROJ.members();
			for (int k = 0; k < children.length; k++) {
				if (!(children[k].getType() == IResource.FOLDER && children[k]
						.getName() == "CVS")) {
					children[k].delete(true, new NullProgressMonitor());
				}
			}
		} catch (CoreException e) {
			// do nothing
		}
	}

	public IResource[] getResources() {
		try {
			IResource[] children = null;
			try {
				children = PROJ.members();
			} catch (CoreException e1) {
				if (DEBUG) {
					e1.printStackTrace();
				}
			}
			for (int k = 0; k < children.length; k++) {
				getAllFiles(children[k]);
			}

			IResource[] res = new IResource[numResources];
			for (int k = 0; k < numResources; k++) {
				res[k] = resourcesToCommit[k];
			}

			return res;
		} catch (NullPointerException e) {
		}

		return null;
	}

	private void getAllFiles(IResource root) {
		try {
			int type = root.getType();
			if (type == IResource.FILE && !root.getFileExtension().equalsIgnoreCase("class")) {
				resourcesToCommit[numResources] = root;
				numResources++;
				return;
			}
			if (type == IResource.FOLDER) {
				IResource[] children = ((IFolder) root).members();
				for (int k = 0; k < children.length; k++) {
					getAllFiles(children[k]);
				}
			}
		} catch (CoreException e) {
		}
	}
	
      public void unmanage(File f){
		File[] members = f.listFiles();
		if (f.isFile()){
			return;
		}
		for (int k=0;k<members.length;k++){
			if (members[k].getName().equalsIgnoreCase("CVS")){
				deleteDir(members[k]);
				members[k].delete();
			}else{
				unmanage(members[k]);
			}
		}
	}
      
    private void deleteDir(File f){
    	if (f.isFile()){
    		f.delete();
    		return;
    	}
    	
    	File[] mem = f.listFiles();
    	for(int k=0;k<mem.length;k++){
    		deleteDir(mem[k]);
    	}
    }
    
	public boolean isShared(IProject project){
		return true;
		/*
		try {
			ICVSRemoteResource remoteRoot = 
				CVSWorkspaceRoot.getRemoteResourceFor(project);
			
			if (remoteRoot == null){
				return false;
			}

	
			ICVSRepositoryLocation repo = remoteRoot.getRepository();
			String host = repo.getHost();
			String location = repo.getRootDirectory();
			String user = repo.getUsername();
			
			IPreferenceStore store = WorkbenchPlugin.getDefault()
			.getPreferenceStore();
			
			if (! host.equalsIgnoreCase(store
					.getString(AmbientPreferenceConstants.HOST))){
				return false;
			}
			
			if (! location.equalsIgnoreCase(store
					.getString(AmbientPreferenceConstants.ROOT))){
				return false;
			}
			
			
			if (! user.equalsIgnoreCase(store
					.getString(AmbientPreferenceConstants.USER_ID))){
				return false;
			}
			
		} catch (Exception e) {
			if (DEBUG){
				e.printStackTrace();
			}
			
			return false;
		}
		return true;
		*/
	}
}