/*******************************************************************************
 * Copyright (c) 2004 Duke University
 *
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.cs.duke.edu/csed/ambient/copyright.html
 * 
*******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package edu.duke.ambient.ui.checkin;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.IHelpContextIds;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.TagConfigurationDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;


public class TagConfiguration extends TagConfigurationDialog {

	public TagConfiguration(Shell shell, ICVSFolder[] roots) {
		super(shell, roots);

	}
	 public static Control createTagDefinitionButtons(final Shell shell, Composite composite, final ICVSFolder[] folders, int hHint, int wHint, final Runnable afterRefresh, final Runnable afterConfigure) {
	 	Composite buttonComp = new Composite(composite, SWT.NONE);
		GridData data = new GridData ();
		data.horizontalAlignment = GridData.END;		
		buttonComp.setLayoutData(data);
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		buttonComp.setLayout (layout);
	 	
	 	final Button refreshButton = createTagRefreshButton(shell, buttonComp, Policy.bind("TagConfigurationDialog.20"), folders[0], afterRefresh); //$NON-NLS-1$
		data = new GridData();
		if(hHint!=0 && wHint!=0) {
			data.heightHint = hHint;
			//don't crop labels with large font
			//int widthHint = wHint;
			//data.widthHint = Math.max(widthHint, refreshButton.computeSize(SWT.DEFAULT, SWT.DEFAULT, true).x);
		}
		data.horizontalAlignment = GridData.END;
		data.horizontalSpan = 1;
		refreshButton.setLayoutData (data);		


		WorkbenchHelp.setHelp(refreshButton, IHelpContextIds.TAG_CONFIGURATION_REFRESHACTION);
		return buttonComp;
	 }
	 
		private static Button createTagRefreshButton(final Shell shell, Composite composite, String title, final ICVSFolder folder, final Runnable runnable) {
			Button refreshButton = new Button(composite, SWT.PUSH);
			refreshButton.setText (title);
			refreshButton.addListener(SWT.Selection, new Listener() {
					public void handleEvent(Event event) {
						try {
							PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress() {
								public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
									try {
										CVSUIPlugin.getPlugin().getRepositoryManager().refreshDefinedTags(folder, false /* replace */, true, monitor);
										Display.getDefault().asyncExec(runnable);
									} catch (TeamException e) {
										throw new InvocationTargetException(e);
									}
								}
							});
						} catch (InterruptedException e) {
							// operation cancelled
						} catch (InvocationTargetException e) {
							CVSUIPlugin.openError(shell, Policy.bind("TagConfigurationDialog.14"), null, e); //$NON-NLS-1$
						}
					}
				});
			updateEnablementOnRefreshButton(refreshButton, folder);
			return refreshButton;		
		 }
		
		 private static void updateEnablementOnRefreshButton(Button refreshButton, ICVSFolder project) {
		 	try {
				String[] files = CVSUIPlugin.getPlugin().getRepositoryManager().getAutoRefreshFiles(project);
				refreshButton.setEnabled(files.length != 0);
			} catch (CVSException e) {
				refreshButton.setEnabled(false);
				CVSUIPlugin.log(e);
			}
	 		
		 }
}
